% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpn.R
\name{rpn}
\alias{rpn}
\title{Reverse Polish Notation converter/interpreter.}
\usage{
rpn(rpn.expr, reverse = TRUE, eval = TRUE, clean = TRUE, vars = list(),
  ops = list())
}
\arguments{
\item{rpn.expr}{[\code{character}]\cr
Character vector representing the expression to convert in (reverse) polish notation.}

\item{reverse}{[\code{logical(1)}]\cr
Is \code{rpn.expr} in reverse polish notation or polish notation?
Default is \code{TRUE}, i.e., reverse polish notation.}

\item{eval}{[\code{logical(1)}]\cr
Shall the expression be evaluated?
Default is \code{TRUE}.}

\item{clean}{[\code{logical(1)}]\cr
Should braces be removed from \code{rpn.expr} before interpretation?
Default is \code{TRUE}.}

\item{vars}{[\code{list}]\cr
Named list of variables which are used in the \code{rpn.expr} beside constants.
Default is the empty list.}

\item{ops}{[\code{list}]\cr
Optional named list of operators. If non-empty, the list must be of key-value
type, i.e., the key is the name of the function and the value is a list with
the 1) the length of the parameter vector the corresponding function expects,
2) a logical value indicating whether the function is a binary infix operator
and third the actual function to be called in case the expression is evaluated.}
}
\value{
List with the components
  \describe{
    \item{infix}{Infix representation of \code{rpn.expr}.}
    \item{value}{Evaluated expression or \code{NA} if \code{eval} is set to \code{FALSE}.}
  }
}
\description{
Expects an expression in (reverse) polish notation as a character vector and
returns the expression in infix notation and the evaluated expression.
}
\details{
This is a pure R implementation.
}
\examples{
# simple example
r = c("4", "6", "*", "6", "+")
rpn(r)
rpn(r, eval = FALSE)

# the same example but with a variable
r = c("x", "6", "*", "6", "+")
rpn(r, eval = TRUE, vars = list(x = 4))
rpn(r, eval = FALSE)

# now a more complex expression with variables and custom operators/functions
rpe = c("x", "5", "6.4", "mysum", "5", "mystuff")
mysum = function(x, y, z) x + y + z # arity 3 and no infix operation
mystuff = function(x, y) 2 * (x + y) # arity 2 and no infix operation
ops = list(mysum = list(3, FALSE, mysum), mystuff = list(2, FALSE, mystuff))
vars = list(x = 3.6)
res = rpn(rpe, ops = ops, vars = vars)

}
\references{
Lukasiewicz, Jan (1957). Aristotle's Syllogistic from the Standpoint of Modern
Formal Logic. Oxford University Press.
}

