% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_db_wrapper_fns.R
\name{dbColumn}
\alias{dbColumn}
\title{Add or remove a column.}
\usage{
dbColumn(
  conn,
  name,
  colname,
  action = c("add", "drop"),
  coltype = "integer",
  cascade = FALSE,
  display = TRUE,
  exec = TRUE
)
}
\arguments{
\item{conn}{A connection object.}

\item{name}{A character string specifying a PostgreSQL table name.}

\item{colname}{A character string specifying the name of the
column}

\item{action}{A character string specifying if the column is to be
added (\code{"add"}, default) or removed (\code{"drop"}).}

\item{coltype}{A character string indicating the type of the
column, if \code{action = "add"}.}

\item{cascade}{Logical. Whether to drop foreign key constraints of
other tables, if \code{action = "drop"}.}

\item{display}{Logical. Whether to display the query (defaults to
\code{TRUE}).}

\item{exec}{Logical. Whether to execute the query (defaults to
\code{TRUE}).}
}
\value{
\code{TRUE} if the column was successfully added or
    removed.
}
\description{
Add or remove a column to/from a table.
}
\examples{
## examples use a dummy connection from DBI package
conn<-DBI::ANSI()
## Add an integer column
dbColumn(conn, name = c("schema", "table"), colname = "field", exec = FALSE)
## Drop a column (with CASCADE)
dbColumn(conn, name = c("schema", "table"), colname = "field", action = "drop",
    cascade = TRUE, exec = FALSE)
}
\seealso{
The PostgreSQL documentation:
    \url{http://www.postgresql.org/docs/current/static/sql-altertable.html}
}
\author{
Mathieu Basille \email{basille@ufl.edu}
}
