% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prevalence.R
\name{sim_prevalence}
\alias{sim_prevalence}
\title{Estimate prevalence using Monte Carlo simulation.}
\usage{
sim_prevalence(
  data,
  index,
  starting_date,
  inc_model,
  surv_model,
  age_column = "age",
  N_boot = 1000,
  age_dead = 100
)
}
\arguments{
\item{data}{A data frame with the corresponding column names provided in
\code{form}.}

\item{index}{The date at which to estimate point prevalence as a string in the format
YYYY-MM-DD.}

\item{starting_date}{The initial date to start simulating prevalence from as a \code{Date} object.
Typically the index date - (Nyears * 365.25). Allows for non-whole year prevalence estimations.}

\item{inc_model}{An object that has a \code{draw_incident_population}
method. See the vignette for further guidance.}

\item{surv_model}{An object that has a \code{predict_survival_probability}
method. See the vignette for further guidance.}

\item{age_column}{A string providing the name of the column that holds patient age. If provided
then patients alive at \code{age_dead} are set to die. This helps combat 'immortal' patients.}

\item{N_boot}{Number of bootstrapped calculations to perform.}

\item{age_dead}{The age at which patients are set to be dead if they are still alive, to prevent
'immortal' patients. Used in conjunction with \code{age_column}.}
}
\value{
A list with the following attributes:
  \item{results}{A data.table containing the simulated incident populations from each
  simulation along with their covariates and survival status at the index.}
  \item{full_surv_model}{The survival model built on the full registry data set.}
  \item{full_inc_model}{The incidence model built on the full registry data set.}
  \item{surv_models}{A list containing survival models built on each bootstrap sample.}
  \item{inc_models}{A list containing incidence models built on each bootstrap sample.}
}
\description{
Estimates prevalent cases at a specific index date by use of Monte Carlo
simulation. Simulated cases are marked with age and sex to enable agreement
with population survival data where a cure model is used, and calculation of
the posterior distributions of each.
}
