% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rpsftm.R
\name{plot.rpsftm}
\alias{plot.rpsftm}
\title{Plot Method}
\usage{
\method{plot}{rpsftm}(x, ...)
}
\arguments{
\item{x}{an object returned from the \code{\link{rpsftm}} function.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
a ggplot plot of the fitted KM curves. The underlying data.frame has variables
\itemize{
\item time: failure time
\item survival: estimated treatment-free survival probability 
\item upper: upper confidence interval at level defined by alpha in the call to rpsftm
\item lower: lower confidence interval at level defined by alpha in the call to rpsftm
\item group: randomised treatment arm
}
}
\description{
Function used to plot the KM curves of the treatment-free transformed times
}
\examples{
fit <- rpsftm(Surv(progyrs, prog)~rand(imm,1-xoyrs/progyrs),immdef, censyrs)
plot(fit)
library(ggplot2)
plot(fit)+
   scale_linetype_discrete(labels=c("Control","Experimental"))+
   ylim(0.5,1)+
   geom_ribbon(aes(ymin=lower, ymax=upper, fill=group), alpha=0.3)+
   labs(x="Time (years)", title=NULL, lty="Arm", fill="Arm")
}
\author{
Simon Bond
}
