% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rquery_fns.R
\name{ex_data_table}
\alias{ex_data_table}
\title{Execute an \code{rquery} pipeline with \code{data.table} sources.}
\usage{
ex_data_table(
  optree,
  ...,
  tables = list(),
  source_usage = NULL,
  source_limit = NULL,
  env = parent.frame()
)
}
\arguments{
\item{optree}{relop operations tree.}

\item{...}{not used, force later arguments to bind by name.}

\item{tables}{named list map from table names used in nodes to data.tables and data.frames.}

\item{source_usage}{list mapping source table names to vectors of columns used.}

\item{source_limit}{if not null limit all table sources to no more than this many rows (used for debugging).}

\item{env}{environment to work in.}
}
\value{
resulting data.table (intermediate tables can somtimes be mutated as is practice with data.table).
}
\description{
\code{data.table}s are looked for by name in the \code{tables} argument and in the execution environment.
Main external execution interface.
}
\details{
\itemize{
 \item \code{\link{ex_data_table_step.relop_drop_columns}}: implement drop columns
 \item \code{\link{ex_data_table_step.relop_extend}}: implement extend/assign operator
 \item \code{\link{ex_data_table_step.relop_natural_join}}: implement natural join
 \item \code{\link{ex_data_table_step.relop_non_sql}}: direct function (non-sql) operator (not implemented for \code{data.table})
 \item \code{\link{ex_data_table_step.relop_null_replace}}: implement NA/NULL replacement
 \item \code{\link{ex_data_table_step.relop_orderby}}: implement row ordering
 \item \code{\link{ex_data_table_step.relop_project}}: implement row ordering
 \item \code{\link{ex_data_table_step.relop_rename_columns}}: implement column renaming
 \item \code{\link{ex_data_table_step.relop_select_columns}}: implement select columns
 \item \code{\link{ex_data_table_step.relop_select_rows}}: implement select rows
 \item \code{\link{ex_data_table_step.relop_sql}}: direct sql operator (not implemented for \code{data.table})
 \item \code{\link{ex_data_table_step.relop_table_source}}: implement data source
 \item \code{\link{ex_data_table_step.relop_theta_join}}: implement theta join  (not implemented for \code{data.table})
 \item \code{\link{ex_data_table_step.relop_unionall}}: implement row binding
}
}
\examples{

  a <- data.table::data.table(x = c(1, 2) , y = c(20, 30), z = c(300, 400))
  optree <- local_td(a) \%.>\%
     select_columns(., c("x", "y")) \%.>\%
     select_rows_nse(., x<2 & y<30)
  cat(format(optree))
  ex_data_table_step(optree)

  # other ways to execute the pipeline include
  as.data.frame(optree)
  as.data.table(optree)
  data.frame(x = 0, y = 4, z = 400) \%.>\% optree


}
