% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extend.R
\name{extend_se}
\alias{extend_se}
\title{Extend data by adding more columns.}
\usage{
extend_se(source, assignments, ..., partitionby = NULL, orderby = NULL,
  desc = FALSE, env = parent.frame())
}
\arguments{
\item{source}{source to select from.}

\item{assignments}{new column assignment expressions.}

\item{...}{force later arguments to bind by name}

\item{partitionby}{partitioning (window function) terms.}

\item{orderby}{ordering (window function) terms.}

\item{desc}{reverse order}

\item{env}{environment to look for values in.}
}
\value{
extend node.
}
\description{
Create a node similar to a Codd extend relational operator (add derived columns).
}
\details{
Allows re-use of column names in the spirit of \code{\link[seplyr]{partition_mutate_se}},
though re-use can break relational property.
partitionby and orderby can only be used with a database that supports window-functions
(such as PostgreSQL).
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
d <- dbi_copy_to(my_db, 'd',
                data.frame(AUC = 0.6, R2 = 0.2))
eqn <- extend_se(d, c("v" := "AUC + R2", "x" := "pmax(AUC,v)"))
cat(format(eqn))
sql <- to_sql(eqn, my_db)
cat(sql)
DBI::dbGetQuery(my_db, sql)

# SQLite can not run the following query
eqn2 <- extend_se(d, "v" := "rank()",
              partitionby = "AUC", orderby = "R2")
sql2 <- to_sql(eqn2, my_db)
cat(sql2)

DBI::dbDisconnect(my_db)

}
