% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop.R
\name{tables_used}
\alias{tables_used}
\title{Return vector of table names used.}
\usage{
tables_used(node, ...)
}
\arguments{
\item{node}{rquery tree to examine.}

\item{...}{(not used)}
}
\value{
named map of tables used.
}
\description{
Return vector of table names used.
}
\examples{

my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
d1 <- dbi_copy_to(my_db, 'd1',
                 data.frame(AUC = 0.6, R2 = 0.2))
d2 <- dbi_copy_to(my_db, 'd2',
                 data.frame(AUC = 0.6, D = 0.3))
eqn <- natural_join(d1, d2)
cat(format(eqn))
print(tables_used(eqn))
DBI::dbDisconnect(my_db)

}
