% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relop.R
\name{columns_used}
\alias{columns_used}
\title{Return columns used}
\usage{
columns_used(x, ..., using = NULL, contract = FALSE)
}
\arguments{
\item{x}{rquery operation tree.}

\item{...}{generic additional arguments (not used)}

\item{using}{character, if not NULL set of columns used from above.}

\item{contract}{logical, if TRUE perform unused value elimination.}
}
\value{
vector of table qualified column names.
}
\description{
Return columns used
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  my_db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d1 <- dbi_copy_to(my_db, 'd1',
                    data.frame(AUC = 0.6, R2 = 0.2))
  d2 <- dbi_copy_to(my_db, 'd2',
                    data.frame(AUC = 0.6, D = 0.3))
  optree <- natural_join(d1, d2)
  cat(format(optree))
  print(columns_used(optree))
  DBI::dbDisconnect(my_db)
}

}
