% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbi_ops.R
\name{dbi_copy_to}
\alias{dbi_copy_to}
\title{Local table to DBI data source.}
\usage{
dbi_copy_to(db, table_name, d, ..., overwrite = FALSE, temporary = TRUE,
  rowidcolumn = NULL)
}
\arguments{
\item{db}{database connection.}

\item{table_name}{name of table to create.}

\item{d}{data.frame to copy to database.}

\item{...}{force later argument to be by name}

\item{overwrite}{passed to \code{\link[DBI]{dbWriteTable}}.}

\item{temporary}{passed to \code{\link[DBI]{dbWriteTable}}.}

\item{rowidcolumn}{character, name to land row-ids.}
}
\value{
a relop representation of the data
}
\description{
Local table to DBI data source.
}
\examples{

if (requireNamespace("RSQLite", quietly = TRUE)) {
  db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
  d <- dbi_copy_to(db, 'd',
                   data.frame(AUC = 0.6, R2 = 0.2))

  sql <- to_sql(d, db)
  cat(sql)
  print(DBI::dbGetQuery(db, "SELECT * FROM d"))
  DBI::dbDisconnect(db)
}

}
\seealso{
\code{\link{dbi_table}}, \code{\link{table_source}}, \code{\link{materialize}}, \code{\link{execute}}, \code{\link{to_sql}}
}
