% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dim-names-common.R
\name{common-dim-names}
\alias{common-dim-names}
\alias{rray_dim_names_common}
\alias{rray_dim_names2}
\title{Find common dimension names}
\usage{
rray_dim_names_common(...)

rray_dim_names2(x, y)
}
\arguments{
\item{x, y, ...}{Objects to find common dimensions for.}
}
\value{
A list of the common dimension names of the inputs.
}
\description{
Obtain a list of common dimension names among a set of objects. For
interactive use, \code{rray_dim_names_common()} is more useful.
}
\details{
\code{rray_dim_names_common()} is the engine that determines what dim names should
be used in the result of arithmetic operations and other functions that
involve multiple rray objects and return a single result.

The rules for determining the set of common dim names between objects
\code{x} and \code{y} (in that order) are:
\itemize{
\item Compute the common \code{dim} between \code{x} and \code{y} using \code{rray_dim_common()}.
\item For each axis along the common \code{dim}:
\itemize{
\item If \code{x} has names for that axis \emph{and} the size of the names vector
is the same as the size of the axis, use those names for that axis.
\item Else if \code{y} has names for that axis \emph{and} the size of the names vector
is the same as the size of the axis, use those names for that axis.
\item Otherwise, the names for that axis is \code{NULL}.
}
}
}
\examples{
library(magrittr)

# 1x2 - Row names but no column names
x <- rray(1, dim = c(1, 2)) \%>\%
  rray_set_row_names("r_from_x")

# 1x1 - Row names and column names
y <- rray(1, dim = c(1, 1)) \%>\%
  rray_set_col_names("c_from_y") \%>\%
  rray_set_row_names("r_from_y")

# 1x1 - Row names but no column names
z <- rray(1, c(1, 1)) \%>\%
  rray_set_row_names("r_from_z")

# Combining y and z
# y has names for both dimensions
# so they are used
rray_dim_names_common(y, z)

# Combining z and y
# - Row names are found first from z
# - But z has no column names
# - So column names are found from y
rray_dim_names_common(z, y)

# Combining x and y
# - Row names are found first from x
# - x has no column names
# - y has column names but they are
#   a different length from the common
#   column dimension (common size of 2)
# - So no column names are used
rray_dim_names_common(x, y)

}
