% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical.R
\name{rray-logical}
\alias{rray-logical}
\alias{rray_logical_and}
\alias{rray_logical_or}
\alias{rray_logical_not}
\alias{rray_any}
\alias{rray_all}
\title{Logical operators}
\usage{
rray_logical_and(x, y)

rray_logical_or(x, y)

rray_logical_not(x)

rray_any(x, axes = NULL)

rray_all(x, axes = NULL)
}
\arguments{
\item{x, y}{Vectors, matrices, arrays, or rrays.}

\item{axes}{An integer vector specifying the axes to reduce over.
\code{1} reduces the number of rows to \code{1}, performing the reduction along the
way. \code{2} does the same, but with the columns, and so on for higher
dimensions. The default reduces along all axes.}
}
\value{
The value of the logical comparison, with broadcasting.

\code{rray_any()} and \code{rray_all()} return a logical object with the same shape
as \code{x} everywhere except along \code{axes}, which have been reduced to size 1.
}
\description{
These functions perform logical operations on arrays, with broadcasting. They
power the logical operators of \code{&}, \code{|}, and \code{!} with rrays, but are
also exported for use with base R objects.
}
\details{
The operators themselves rely on R's dispatching rules to
dispatch to the correct rray logical operator. When comparing rrays with
base R matrices and arrays, this generally works fine. However, if you
compare classed objects like \code{factor("x") & rray(1)} then a fall through
error is thrown. There is nothing we can do about
this. See \code{?groupGeneric} for more information on this.

The behavior of comparing an array with a length 0 dimension
with another array is slightly different than base R since
broadcasting behavior is well defined. Length 0 dimensions are not exceptions
to the normal broadcasting rules. Comparing dimensions of \code{0} and \code{1}, the
common dimension is \code{0} because \code{1} always becomes the other dimension in the
comparison. On the other hand, comparing dimensions \code{0} and \code{2} is an error
because neither are \code{1}, and they are not identical.
}
\examples{
x <- rray(TRUE, c(2, 2, 3))
y <- matrix(c(TRUE, FALSE))

# `TRUE` wherever `y` is broadcasted to be `TRUE`
x & y

# ---------------------------------------------------------------------------
# Behavior with edge cases

x <- rray(TRUE, c(1, 2))

# The common dim is (0, 2)
logical() & x

# You can have empty arrays with shape
# The common dim is (0, 2, 2)
y <- array(logical(), c(0, 1, 2))
x & y

# You cannot broadcast dimensions
# of 2 and 0. Following standard
# broadcasting rules, they do not
# match and neither are 1, so an
# error should be thrown
try(x & array(logical(), c(1, 0)))

}
