% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiply-add.R
\name{rray_multiply_add}
\alias{rray_multiply_add}
\title{Fused multiply-add}
\usage{
rray_multiply_add(x, y, z)
}
\arguments{
\item{x, y, z}{A vector, matrix, array or rray.}
}
\value{
An object of the common type of the inputs, containing the result of the
multiply-add operation.
}
\description{
\code{rray_multiply_add()} computes \code{x * y + z}, with broadcasting.
It is more efficient than simply doing those operations in sequence.
}
\examples{
rray_multiply_add(2, 3, 5)

# Using broadcasting
rray_multiply_add(matrix(1:5), matrix(1:2, nrow = 1L), 3L)

# ^ Equivalent to:
x <- matrix(rep(1:5, 2), ncol = 2)
y <- matrix(rep(1:2, 5), byrow = TRUE, ncol = 2)
z <- matrix(3L, nrow = 5, ncol = 2)
x * y + z

}
