/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys;

import com.hp.hpl.jena.graph.Capabilities;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.IllegalParameterException;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.ClauseEntry;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.rulesys.Functor;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.RuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.shared.WrappedIOException;
import com.hp.hpl.jena.vocabulary.ReasonerVocabulary;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FBRuleReasoner
implements RuleReasoner {
    protected ReasonerFactory factory;
    protected List<Rule> rules = new ArrayList<Rule>();
    protected Graph schemaGraph;
    protected boolean recordDerivations = false;
    boolean traceOn = false;
    protected static final boolean cachePreload = true;
    protected InfGraph preload;
    protected Resource configuration;
    protected Capabilities capabilities;

    public FBRuleReasoner(List<Rule> rules) {
        if (rules == null) {
            throw new NullPointerException("null rules");
        }
        this.rules = rules;
    }

    public FBRuleReasoner(ReasonerFactory factory) {
        this(new ArrayList<Rule>(), factory);
    }

    public FBRuleReasoner(ReasonerFactory factory, Resource configuration) {
        this(new ArrayList<Rule>(), factory);
        this.configuration = configuration;
        if (configuration != null) {
            this.loadConfiguration(configuration);
        }
    }

    protected void loadConfiguration(Resource configuration) {
        StmtIterator i = configuration.listProperties();
        while (i.hasNext()) {
            Statement st = i.nextStatement();
            this.doSetRDFNodeParameter(st.getPredicate(), st.getObject());
        }
    }

    public FBRuleReasoner(List<Rule> rules, ReasonerFactory factory) {
        this(rules);
        this.factory = factory;
    }

    protected FBRuleReasoner(List<Rule> rules, Graph schemaGraph, ReasonerFactory factory) {
        this(rules, factory);
        this.schemaGraph = schemaGraph;
    }

    public FBRuleReasoner addRules(List<Rule> rules) {
        ArrayList<Rule> combined = new ArrayList<Rule>(this.rules);
        combined.addAll(rules);
        this.setRules(combined);
        return this;
    }

    @Override
    public Model getReasonerCapabilities() {
        if (this.factory != null) {
            return this.factory.getCapabilities();
        }
        return null;
    }

    public Graph getBoundSchema() {
        return this.schemaGraph;
    }

    @Override
    public void addDescription(Model configSpec, Resource base) {
        if (this.configuration != null) {
            StmtIterator i = this.configuration.listProperties();
            while (i.hasNext()) {
                Statement st = i.nextStatement();
                configSpec.add(base, st.getPredicate(), st.getObject());
            }
        }
    }

    @Override
    public boolean supportsProperty(Property property) {
        if (this.factory == null) {
            return false;
        }
        Model caps = this.factory.getCapabilities();
        Resource root = caps.getResource(this.factory.getURI());
        return caps.contains(root, ReasonerVocabulary.supportsP, property);
    }

    @Override
    public Reasoner bindSchema(Graph tbox) throws ReasonerException {
        if (this.schemaGraph != null) {
            throw new ReasonerException("Can only bind one schema at a time to an OWLRuleReasoner");
        }
        FBRuleInfGraph graph = new FBRuleInfGraph((Reasoner)this, this.rules, (Graph)this.getPreload(), tbox);
        graph.prepare();
        FBRuleReasoner fbr = new FBRuleReasoner(this.rules, graph, this.factory);
        fbr.setDerivationLogging(this.recordDerivations);
        fbr.setTraceOn(this.traceOn);
        return fbr;
    }

    @Override
    public Reasoner bindSchema(Model tbox) throws ReasonerException {
        return this.bindSchema(tbox.getGraph());
    }

    @Override
    public InfGraph bind(Graph data) throws ReasonerException {
        ReificationStyle style = data.getReifier().getStyle();
        InfGraph schemaArg = this.schemaGraph == null ? this.getPreload() : (FBRuleInfGraph)this.schemaGraph;
        FBRuleInfGraph graph = new FBRuleInfGraph((Reasoner)this, this.rules, (Graph)schemaArg, style);
        graph.setDerivationLogging(this.recordDerivations);
        graph.setTraceOn(this.traceOn);
        graph.rebind(data);
        return graph;
    }

    @Override
    public void setRules(List<Rule> rules) {
        this.rules = rules;
        this.preload = null;
        if (this.schemaGraph != null) {
            throw new ReasonerException("Cannot change the rule set for a bound rule reasoner.\nSet the rules before calling bindSchema");
        }
    }

    @Override
    public List<Rule> getRules() {
        return this.rules;
    }

    public static List<Rule> loadRules(String fileName) {
        try {
            return Rule.parseRules(Util.loadRuleParserFromResourceFile(fileName));
        }
        catch (WrappedIOException e) {
            throw new ReasonerException("Can't load rules file: " + fileName, e.getCause());
        }
    }

    public synchronized void tablePredicate(Node predicate) {
        Rule tablePredicateRule = new Rule("", new ClauseEntry[]{new Functor("table", new Node[]{predicate})}, new ClauseEntry[0]);
        this.rules.add(tablePredicateRule);
    }

    protected synchronized InfGraph getPreload() {
        if (this.preload == null) {
            this.preload = new FBRuleInfGraph(this, this.rules, null);
            this.preload.prepare();
        }
        return this.preload;
    }

    @Override
    public void setDerivationLogging(boolean logOn) {
        this.recordDerivations = logOn;
    }

    public void setTraceOn(boolean state) {
        this.traceOn = state;
    }

    public boolean isTraceOn() {
        return this.traceOn;
    }

    @Override
    public void setParameter(Property parameter, Object value) {
        if (!this.doSetParameter(parameter, value)) {
            throw new IllegalParameterException("RuleReasoner does not recognize configuration parameter " + parameter);
        }
        if (this.configuration == null) {
            Model configModel = ModelFactory.createDefaultModel();
            this.configuration = configModel.createResource();
        }
        Util.updateParameter(this.configuration, parameter, value);
    }

    protected boolean doSetRDFNodeParameter(Property parameter, RDFNode value) {
        return value instanceof Resource && this.doSetResourceParameter(parameter, (Resource)value) || value instanceof Literal && this.doSetParameter(parameter, ((Literal)value).getValue()) || this.doSetParameter(parameter, ((Object)value).toString());
    }

    protected boolean doSetResourceParameter(Property parameter, Resource value) {
        return false;
    }

    protected boolean doSetParameter(Property parameter, Object value) {
        if (parameter.equals(ReasonerVocabulary.PROPderivationLogging)) {
            this.recordDerivations = Util.convertBooleanPredicateArg(parameter, value);
            return true;
        }
        if (parameter.equals(ReasonerVocabulary.PROPtraceOn)) {
            this.traceOn = Util.convertBooleanPredicateArg(parameter, value);
            return true;
        }
        return false;
    }

    @Override
    public Capabilities getGraphCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new BaseInfGraph.InfCapabilities();
        }
        return this.capabilities;
    }
}

