/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.TableFactory;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op0;
import com.hp.hpl.jena.sparql.algebra.table.TableUnit;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;

public class OpTable
extends Op0 {
    private Table table;

    public static OpTable unit() {
        return new OpTable(TableFactory.createUnit());
    }

    public static OpTable create(Table table) {
        return new OpTable(table);
    }

    public static OpTable empty() {
        return new OpTable(TableFactory.createEmpty());
    }

    private OpTable(Table table) {
        this.table = table;
    }

    public boolean isJoinIdentity() {
        return this.table instanceof TableUnit;
    }

    public Table getTable() {
        return this.table;
    }

    public String getName() {
        return "table";
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op apply(Transform transform) {
        return transform.transform(this);
    }

    public Op copy() {
        return new OpTable(this.table);
    }

    public int hashCode() {
        return this.table.hashCode();
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpTable)) {
            return false;
        }
        OpTable opTable = (OpTable)other;
        return this.table.equals(opTable.table);
    }
}

