/*
 * Decompiled with CFR 0.152.
 */
package org.openjena.riot.pipeline;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.graph.NodeTransform;
import org.openjena.atlas.lib.Sink;
import org.openjena.atlas.lib.SinkWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinkQuadNodeTransform
extends SinkWrapper<Quad> {
    private final NodeTransform graphNodeTransform;
    private final NodeTransform subjTransform;
    private final NodeTransform predTransform;
    private final NodeTransform objTransform;

    public SinkQuadNodeTransform(Sink<Quad> sink, NodeTransform nodeTransform) {
        this(sink, nodeTransform, nodeTransform, nodeTransform, nodeTransform);
    }

    public SinkQuadNodeTransform(Sink<Quad> sink, NodeTransform graphNodeTransform, NodeTransform subjTransform, NodeTransform predTransform, NodeTransform objTransform) {
        super(sink);
        this.graphNodeTransform = graphNodeTransform;
        this.subjTransform = subjTransform;
        this.predTransform = predTransform;
        this.objTransform = objTransform;
    }

    @Override
    public void send(Quad quad) {
        Node g = quad.getGraph();
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g1 = SinkQuadNodeTransform.apply(this.graphNodeTransform, g);
        Node s1 = SinkQuadNodeTransform.apply(this.subjTransform, s);
        Node p1 = SinkQuadNodeTransform.apply(this.predTransform, p);
        Node o1 = SinkQuadNodeTransform.apply(this.objTransform, o);
        if (o != o1 || p != p1 || s != s1 || g != g1) {
            quad = new Quad(g1, s1, p1, o1);
        }
        super.send(quad);
    }

    private static Node apply(NodeTransform nodeTransform, Node node) {
        if (nodeTransform == null) {
            return node;
        }
        return nodeTransform.convert(node);
    }
}

