/*
 * Decompiled with CFR 0.152.
 */
package tdb.cmdline;

import arq.cmd.CmdException;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import arq.cmdline.ModAssembler;
import com.hp.hpl.jena.tdb.base.file.Location;
import java.io.File;
import tdb.cmdline.ModLocation;

public class ModTDBAssembler
extends ModAssembler {
    private ModLocation modLocation = new ModLocation();
    public static final String defaultAssemblerFile = "tdb.ttl";
    protected boolean useDefaultAssemblerFile = false;

    public ModTDBAssembler() {
        ModAssembler.assemblerDescDecl.addName("tdb");
    }

    public void processArgs(CmdArgModule cmdLine) {
        int count = 0;
        this.modLocation.processArgs(cmdLine);
        super.processArgs(cmdLine);
        if (super.getAssemblerFile() != null) {
            ++count;
        }
        if (this.modLocation.getLocation() != null) {
            ++count;
        }
        if (count == 0) {
            this.useDefaultAssemblerFile = true;
        }
        if (count > 1) {
            throw new CmdException("Only one of an assembler file and a location");
        }
    }

    public void registerWith(CmdGeneral cmdLine) {
        super.registerWith(cmdLine);
        cmdLine.addModule((ArgModuleGeneral)this.modLocation);
        cmdLine.getUsage().addUsage("--tdb=", "Assembler description file");
    }

    public Location getLocation() {
        return this.modLocation.getLocation();
    }

    public String getAssemblerFile() {
        File f;
        if (this.useDefaultAssemblerFile && (f = new File(defaultAssemblerFile)).exists()) {
            return defaultAssemblerFile;
        }
        return super.getAssemblerFile();
    }
}

