/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;

public class HashedTripleBunch
extends HashCommon<Triple>
implements TripleBunch {
    public HashedTripleBunch(TripleBunch b) {
        super(HashedTripleBunch.nextSize((int)((double)b.size() / 0.5)));
        ExtendedIterator<Triple> it = b.iterator();
        while (it.hasNext()) {
            this.add((Triple)it.next());
        }
        this.changes = 0;
    }

    protected Triple[] newKeyArray(int size) {
        return new Triple[size];
    }

    @Override
    public boolean contains(Triple t) {
        return this.findSlot(t) < 0;
    }

    protected int findSlotBySameValueAs(Triple key) {
        int index = this.initialIndexFor(key);
        Triple current;
        while ((current = ((Triple[])this.keys)[index]) != null) {
            if (key.matches(current)) {
                return ~index;
            }
            if (--index >= 0) continue;
            index += this.capacity;
        }
        return index;
    }

    @Override
    public boolean containsBySameValueAs(Triple t) {
        return this.findSlotBySameValueAs(t) < 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    public int currentCapacity() {
        return this.capacity;
    }

    @Override
    public void add(Triple t) {
        ((Triple[])this.keys)[this.findSlot(t)] = t;
        ++this.changes;
        if (++this.size > this.threshold) {
            this.grow();
        }
    }

    protected void grow() {
        Object[] oldContents = this.keys;
        int oldCapacity = this.capacity;
        this.growCapacityAndThreshold();
        this.keys = new Triple[this.capacity];
        Triple[] newKeys = this.keys;
        for (int i = 0; i < oldCapacity; ++i) {
            Triple t = (Triple)oldContents[i];
            if (t == null) continue;
            newKeys[this.findSlot(t)] = t;
        }
    }

    @Override
    public void remove(Triple t) {
        super.remove(t);
        ++this.changes;
    }

    @Override
    public ExtendedIterator<Triple> iterator() {
        return this.iterator(HashCommon.NotifyEmpty.ignore);
    }

    @Override
    public ExtendedIterator<Triple> iterator(HashCommon.NotifyEmpty container) {
        return this.keyIterator(container);
    }
}

