/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.ModelReader;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.vocabulary.OntDocManagerVocab;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntDocumentManager {
    public static final String DEFAULT_METADATA_PATH = "file:ont-policy.rdf;file:etc/ont-policy.rdf";
    public static final String NS = "http://jena.hpl.hp.com/schemas/2003/03/ont-manager#";
    public static final String ANCHOR = "#";
    public static final Resource ONTOLOGY_SPEC = OntDocManagerVocab.OntologySpec;
    public static final Property PUBLIC_URI = OntDocManagerVocab.publicURI;
    public static final Property ALT_URL = OntDocManagerVocab.altURL;
    public static final Property PREFIX = OntDocManagerVocab.prefix;
    public static final Property LANGUAGE = OntDocManagerVocab.language;
    public static final Resource DOC_MGR_POLICY = OntDocManagerVocab.DocumentManagerPolicy;
    public static final Property CACHE_MODELS = OntDocManagerVocab.cacheModels;
    public static final Property PROCESS_IMPORTS = OntDocManagerVocab.processImports;
    public static final Property IGNORE_IMPORT = OntDocManagerVocab.ignoreImport;
    public static final Property USE_DECLARED_NS_PREFIXES = OntDocManagerVocab.useDeclaredNsPrefixes;
    private static OntDocumentManager s_instance = null;
    private static Logger log = LoggerFactory.getLogger(OntDocumentManager.class);
    protected String m_searchPath = "file:ont-policy.rdf;file:etc/ont-policy.rdf";
    protected FileManager m_fileMgr;
    protected boolean m_usingGlobalFileMgr = false;
    protected boolean m_processImports = true;
    protected Set<String> m_ignoreImports = new HashSet<String>();
    protected PrefixMapping m_prefixMap = new PrefixMappingImpl();
    protected boolean m_useDeclaredPrefixes = true;
    protected String m_policyURL;
    protected ReadFailureHandler m_rfHandler;
    protected ReadHook m_readHook = new DefaultReadHook();

    public OntDocumentManager() {
        this(DEFAULT_METADATA_PATH);
    }

    public OntDocumentManager(String path) {
        this(null, path);
    }

    public OntDocumentManager(FileManager fileMgr, String path) {
        this.setFileManager(fileMgr);
        this.setDefaults();
        this.m_searchPath = path == null ? "" : path;
        this.initialiseMetadata(this.m_searchPath);
    }

    public OntDocumentManager(Model config) {
        this(null, config);
    }

    public OntDocumentManager(FileManager fileMgr, Model config) {
        this.setFileManager(fileMgr);
        this.setDefaults();
        this.configure(config, false);
    }

    public static OntDocumentManager getInstance() {
        if (s_instance == null) {
            s_instance = new OntDocumentManager();
        }
        return s_instance;
    }

    public FileManager getFileManager() {
        return this.m_fileMgr;
    }

    public ReadHook setReadHook(ReadHook hook) {
        if (hook == null) {
            throw new IllegalArgumentException("ReadHook cannot be null");
        }
        ReadHook rh = this.m_readHook;
        this.m_readHook = hook;
        return rh;
    }

    public ReadHook getReadHook() {
        return this.m_readHook;
    }

    public void setFileManager() {
        this.setFileManager(new FileManager(FileManager.get()));
        this.m_usingGlobalFileMgr = true;
    }

    public void setFileManager(FileManager fileMgr) {
        if (fileMgr == null) {
            this.setFileManager();
        } else {
            this.m_fileMgr = fileMgr;
            this.m_usingGlobalFileMgr = false;
        }
    }

    public String getMetadataSearchPath() {
        return this.m_searchPath;
    }

    public void setMetadataSearchPath(String path, boolean replace) {
        if (replace) {
            this.reset();
        }
        this.m_searchPath = path;
        this.m_policyURL = null;
        this.initialiseMetadata(path);
    }

    public void setReadFailureHandler(ReadFailureHandler rfHandler) {
        this.m_rfHandler = rfHandler;
    }

    public ReadFailureHandler getReadFailureHandler() {
        return this.m_rfHandler;
    }

    public void configure(Model config) {
        this.configure(config, true);
    }

    public void configure(Model config, boolean reset) {
        if (reset) {
            this.reset(false);
        }
        this.processMetadata(config);
    }

    public void reset(boolean reload) {
        if (this.m_usingGlobalFileMgr) {
            this.setFileManager();
        } else {
            this.getFileManager().resetCache();
        }
        this.m_ignoreImports.clear();
        this.m_prefixMap = new PrefixMappingImpl();
        this.setDefaults();
        if (reload) {
            this.initialiseMetadata(this.m_searchPath);
        }
    }

    public void reset() {
        this.reset(false);
    }

    public Iterator<String> listDocuments() {
        return this.getFileManager().getLocationMapper().listAltEntries();
    }

    public String doAltURLMapping(String uri) {
        return this.getFileManager().mapURI(uri);
    }

    public Model getModel(String uri) {
        Model m = this.getFileManager().getFromCache(uri);
        if (m != null && m.isClosed()) {
            this.getFileManager().removeCacheModel(uri);
            m = null;
        }
        return m;
    }

    public void addAltEntry(String docURI, String locationURL) {
        this.getFileManager().getLocationMapper().addAltEntry(docURI, locationURL);
    }

    public void addModel(String docURI, Model model) {
        this.addModel(docURI, model, false);
    }

    public void addModel(String docURI, Model model, boolean replace) {
        if (this.getFileManager().isCachingModels() && (replace || !this.getFileManager().hasCachedModel(docURI))) {
            this.getFileManager().addCacheModel(docURI, model);
        }
    }

    public void forget(String docURI) {
        this.getFileManager().getLocationMapper().removeAltEntry(docURI);
        this.getFileManager().removeCacheModel(docURI);
    }

    public OntModel getOntology(String uri, OntModelSpec spec) {
        OntModelSpec _spec = spec;
        if (_spec.getDocumentManager() != this) {
            _spec = new OntModelSpec(spec);
            _spec.setDocumentManager(this);
        }
        if (this.getFileManager().hasCachedModel(uri)) {
            Model cached = this.getFileManager().getFromCache(uri);
            if (cached instanceof OntModel) {
                return (OntModel)cached;
            }
            return ModelFactory.createOntologyModel(_spec, cached);
        }
        OntModel m = ModelFactory.createOntologyModel(_spec, null);
        this.read(m, uri, true);
        this.addModel(uri, m);
        return m;
    }

    public boolean getProcessImports() {
        return this.m_processImports;
    }

    public boolean getCacheModels() {
        return this.getFileManager().isCachingModels();
    }

    public void setProcessImports(boolean processImports) {
        this.m_processImports = processImports;
    }

    public void setCacheModels(boolean cacheModels) {
        this.getFileManager().setModelCaching(cacheModels);
    }

    public void addIgnoreImport(String uri) {
        this.m_ignoreImports.add(uri);
    }

    public void removeIgnoreImport(String uri) {
        this.m_ignoreImports.remove(uri);
    }

    public Iterator<String> listIgnoredImports() {
        return this.m_ignoreImports.iterator();
    }

    public boolean ignoringImport(String uri) {
        return this.m_ignoreImports.contains(uri);
    }

    public void clearCache() {
        this.getFileManager().resetCache();
    }

    public void loadImports(OntModel model) {
        if (this.m_processImports) {
            ArrayList<String> readQueue = new ArrayList<String>();
            this.queueImports(model, readQueue, model.getProfile());
            this.loadImports(model, readQueue);
        }
    }

    public void loadImport(OntModel model, String uri) {
        if (this.m_processImports) {
            ArrayList<String> readQueue = new ArrayList<String>();
            readQueue.add(uri);
            this.loadImports(model, readQueue);
        }
    }

    public void unloadImport(OntModel model, String uri) {
        if (this.m_processImports) {
            ArrayList<String> unloadQueue = new ArrayList<String>();
            unloadQueue.add(uri);
            this.unloadImports(model, unloadQueue);
        }
    }

    public String getLoadedPolicyURL() {
        return this.m_policyURL;
    }

    protected void loadImports(OntModel model, List<String> readQueue) {
        while (!readQueue.isEmpty()) {
            String importURI = readQueue.remove(0);
            if (model.hasLoadedImport(importURI) || this.ignoringImport(importURI)) continue;
            this.loadImport(model, importURI, readQueue);
        }
        model.rebind();
    }

    protected void unloadImports(OntModel model, List<String> unloadQueue) {
        while (!unloadQueue.isEmpty()) {
            Model importModel;
            String importURI = unloadQueue.remove(0);
            if (!model.hasLoadedImport(importURI) || (importModel = this.getModel(importURI)) == null) continue;
            ArrayList<String> imports = new ArrayList<String>();
            StmtIterator i = importModel.listStatements(null, model.getProfile().IMPORTS(), (RDFNode)null);
            while (i.hasNext()) {
                imports.add(i.nextStatement().getResource().getURI());
            }
            model.removeSubModel(importModel, false);
            model.removeLoadedImport(importURI);
            i = model.listStatements(null, model.getProfile().IMPORTS(), (RDFNode)null);
            while (i.hasNext()) {
                imports.remove(i.nextStatement().getResource().getURI());
            }
            unloadQueue.addAll(imports);
        }
        model.rebind();
    }

    protected void queueImports(Model model, List<String> readQueue, Profile profile) {
        if (model instanceof OntModel) {
            readQueue.addAll(((OntModel)model).listImportedOntologyURIs());
        } else {
            StmtIterator i = model.listStatements(null, profile.IMPORTS(), (RDFNode)null);
            while (i.hasNext()) {
                readQueue.add(i.nextStatement().getResource().getURI());
            }
        }
    }

    protected void initialiseMetadata(String path) {
        Model metadata = this.findMetadata(path);
        if (metadata != null) {
            this.processMetadata(metadata);
        }
    }

    protected Model findMetadata(String configPath) {
        if (configPath == null) {
            return null;
        }
        FileManager fm = new FileManager();
        fm.addLocatorFile();
        fm.addLocatorURL();
        fm.addLocatorClassLoader(fm.getClass().getClassLoader());
        try {
            String uri = null;
            InputStream in = null;
            StringTokenizer pathElems = new StringTokenizer(configPath, ";");
            while (in == null && pathElems.hasMoreTokens()) {
                uri = pathElems.nextToken();
                in = fm.openNoMap(uri);
            }
            if (in != null) {
                String syntax = FileUtils.guessLang(uri);
                Model model = ModelFactory.createDefaultModel();
                model.read(in, uri, syntax);
                this.m_policyURL = uri;
                return model;
            }
        }
        catch (JenaException e) {
            log.warn("Exception while reading configuration: " + e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected void processMetadata(Model metadata) {
        this.getFileManager().getLocationMapper().processConfig(metadata);
        ResIterator i = metadata.listResourcesWithProperty(RDF.type, DOC_MGR_POLICY);
        while (i.hasNext()) {
            Resource policy = i.nextResource();
            StmtIterator j = policy.listProperties();
            while (j.hasNext()) {
                Statement s = j.nextStatement();
                Property pred = s.getPredicate();
                if (pred.equals(CACHE_MODELS)) {
                    this.setCacheModels(s.getBoolean());
                    continue;
                }
                if (pred.equals(PROCESS_IMPORTS)) {
                    this.setProcessImports(s.getBoolean());
                    continue;
                }
                if (!pred.equals(IGNORE_IMPORT)) continue;
                this.addIgnoreImport(s.getResource().getURI());
            }
        }
        i = metadata.listResourcesWithProperty(RDF.type, ONTOLOGY_SPEC);
        while (i.hasNext()) {
            Resource root = i.nextResource();
            Statement s = root.getProperty(PUBLIC_URI);
            if (s != null) {
                String publicURI = s.getResource().getURI();
                s = root.getProperty(ALT_URL);
                if (s == null) continue;
                this.addAltEntry(publicURI, s.getResource().getURI());
                continue;
            }
            log.warn("Ontology specification node lists no public URI - node ignored");
        }
    }

    protected void loadImport(OntModel model, String importURI, List<String> readQueue) {
        if (this.m_processImports) {
            model.addLoadedImport(importURI);
            Model in = this.fetchPossiblyCachedImportModel(model, importURI);
            if (in != model) {
                this.queueImports(in, readQueue, model.getProfile());
                model.addSubModel(in, false);
                this.addModel(importURI, in);
            }
        }
    }

    private Model fetchPossiblyCachedImportModel(OntModel model, String importURI) {
        Model in = this.getModel(importURI);
        if (in == null) {
            in = this.fetchLoadedImportModel(model.getSpecification(), importURI);
        }
        return in;
    }

    private Model fetchLoadedImportModel(OntModelSpec spec, String importURI) {
        Model m;
        ModelMaker maker = spec.getImportModelMaker();
        if (maker.hasModel(importURI)) {
            m = maker.getModel(importURI);
            if (!m.isClosed()) {
                return m;
            }
            maker.removeModel(importURI);
        }
        m = spec.getImportModelGetter().getModel(importURI, new ModelReader(){

            @Override
            public Model readModel(Model toRead, String URL2) {
                OntDocumentManager.this.read(toRead, URL2, true);
                return toRead;
            }
        });
        return m;
    }

    protected boolean read(Model model, String uri, boolean warn) {
        boolean success = false;
        try {
            String source = this.m_readHook.beforeRead(model, uri, this);
            if (source == null) {
                log.warn("Read hook returned null source, so assuming old value: " + uri);
                source = uri;
            } else {
                this.getFileManager().readModel(model, source);
            }
            this.m_readHook.afterRead(model, source, this);
            success = true;
        }
        catch (Exception e) {
            if (this.getReadFailureHandler() != null) {
                this.getReadFailureHandler().handleFailedRead(uri, model, e);
            }
            log.warn("An error occurred while attempting to read from " + uri + ". Msg was '" + e.getMessage() + "'.", (Throwable)e);
        }
        return success;
    }

    protected void setDefaults() {
        this.setCacheModels(true);
        this.setProcessImports(true);
        this.setDefaultPrefixMappings();
    }

    protected void setDefaultPrefixMappings() {
        this.m_prefixMap.setNsPrefixes(PrefixMapping.Standard);
        this.m_prefixMap.removeNsPrefix("dc");
    }

    public static class DefaultReadHook
    implements ReadHook {
        @Override
        public void afterRead(Model model, String source, OntDocumentManager odm) {
        }

        @Override
        public String beforeRead(Model model, String source, OntDocumentManager odm) {
            return source;
        }
    }

    public static interface ReadHook {
        public String beforeRead(Model var1, String var2, OntDocumentManager var3);

        public void afterRead(Model var1, String var2, OntDocumentManager var3);
    }

    public static interface ReadFailureHandler {
        public void handleFailedRead(String var1, Model var2, Exception var3);
    }
}

