/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.OpWalker;
import com.hp.hpl.jena.sparql.algebra.Table;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpExtend;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpMinus;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpPath;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpPropFunc;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class OpVars {
    @Deprecated
    public static Set<Var> patternVars(Op op) {
        return OpVars.visibleVars(op);
    }

    public static Set<Var> visibleVars(Op op) {
        HashSet<Var> acc = new HashSet<Var>();
        OpVars.visibleVars(op, acc);
        return acc;
    }

    public static void visibleVars(Op op, Set<Var> acc) {
        OpVarsPattern visitor = new OpVarsPattern(acc);
        OpWalker.walk(new WalkerVisitorVisible(visitor, acc), op);
    }

    public static Collection<Var> mentionedVars(Op op) {
        HashSet<Var> acc = new HashSet<Var>();
        OpVars.mentionedVars(op, acc);
        return acc;
    }

    public static void mentionedVars(Op op, Set<Var> acc) {
        OpVarsQuery visitor = new OpVarsQuery(acc);
        OpWalker.walk(op, visitor);
    }

    public static Collection<Var> vars(BasicPattern pattern) {
        HashSet<Var> acc = new HashSet<Var>();
        OpVars.vars(pattern, acc);
        return acc;
    }

    public static void vars(BasicPattern pattern, Collection<Var> acc) {
        for (Triple triple : pattern) {
            OpVars.addVarsFromTriple(acc, triple);
        }
    }

    private static void addVarsFromTriple(Collection<Var> acc, Triple t) {
        OpVars.addVar(acc, t.getSubject());
        OpVars.addVar(acc, t.getPredicate());
        OpVars.addVar(acc, t.getObject());
    }

    private static void addVarsFromQuad(Collection<Var> acc, Quad q) {
        OpVars.addVar(acc, q.getSubject());
        OpVars.addVar(acc, q.getPredicate());
        OpVars.addVar(acc, q.getObject());
        OpVars.addVar(acc, q.getGraph());
    }

    private static void addVar(Collection<Var> acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(Var.alloc(n));
        }
    }

    private static class OpVarsQuery
    extends OpVarsPattern {
        OpVarsQuery(Set<Var> acc) {
            super(acc);
        }

        @Override
        public void visit(OpFilter opFilter) {
            opFilter.getExprs().varsMentioned(this.acc);
        }

        @Override
        public void visit(OpOrder opOrder) {
            for (SortCondition sc : opOrder.getConditions()) {
                Set<Var> x = sc.getExpression().getVarsMentioned();
                this.acc.addAll(x);
            }
        }
    }

    private static class OpVarsPattern
    extends OpVisitorBase {
        protected Set<Var> acc;

        OpVarsPattern(Set<Var> acc) {
            this.acc = acc;
        }

        @Override
        public void visit(OpBGP opBGP) {
            OpVars.vars(opBGP.getPattern(), this.acc);
        }

        @Override
        public void visit(OpPath opPath) {
            OpVars.addVar(this.acc, opPath.getTriplePath().getSubject());
            OpVars.addVar(this.acc, opPath.getTriplePath().getObject());
        }

        @Override
        public void visit(OpQuadPattern quadPattern) {
            OpVars.addVar(this.acc, quadPattern.getGraphNode());
            OpVars.vars(quadPattern.getBasicPattern(), this.acc);
        }

        @Override
        public void visit(OpGraph opGraph) {
            OpVars.addVar(this.acc, opGraph.getNode());
        }

        @Override
        public void visit(OpDatasetNames dsNames) {
            OpVars.addVar(this.acc, dsNames.getGraphNode());
        }

        @Override
        public void visit(OpTable opTable) {
            Table t = opTable.getTable();
            this.acc.addAll(t.getVars());
        }

        @Override
        public void visit(OpProject opProject) {
            throw new ARQInternalErrorException();
        }

        @Override
        public void visit(OpAssign opAssign) {
            this.acc.addAll(opAssign.getVarExprList().getVars());
        }

        @Override
        public void visit(OpExtend opExtend) {
            this.acc.addAll(opExtend.getVarExprList().getVars());
        }

        @Override
        public void visit(OpPropFunc opPropFunc) {
            this.addvars(opPropFunc.getSubjectArgs());
            this.addvars(opPropFunc.getObjectArgs());
        }

        private void addvars(PropFuncArg pfArg) {
            if (pfArg.isNode()) {
                OpVars.addVar(this.acc, pfArg.getArg());
                return;
            }
            for (Node n : pfArg.getArgList()) {
                OpVars.addVar(this.acc, n);
            }
        }

        @Override
        public void visit(OpProcedure opProc) {
            opProc.getArgs().varsMentioned(this.acc);
        }
    }

    private static class WalkerVisitorVisible
    extends OpWalker.WalkerVisitor {
        private final Collection<Var> acc;

        public WalkerVisitorVisible(OpVarsPattern visitor, Collection<Var> acc) {
            super(visitor);
            this.acc = acc;
        }

        @Override
        public void visit(OpProject op) {
            this.before(op);
            this.acc.addAll(op.getVars());
            this.after(op);
        }

        @Override
        public void visit(OpMinus op) {
            this.before(op);
            if (op.getLeft() != null) {
                op.getLeft().visit(this);
            }
            if (this.visitor != null) {
                op.visit(this.visitor);
            }
            this.after(op);
        }
    }
}

