/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonException;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonValue;

public class JsonAccess {
    public static JsonValue accessPath(JsonValue obj, String ... path) {
        for (int i = 0; i < path.length; ++i) {
            String p = path[i];
            if (!obj.isObject()) {
                throw new JsonException("Path traverses non-object");
            }
            obj = obj.getAsObject().get(p);
        }
        return obj;
    }

    public static JsonValue access(JsonValue obj, Object ... path) {
        for (int i = 0; i < path.length; ++i) {
            Object p = path[i];
            if (p instanceof String) {
                if (!obj.isObject()) {
                    throw new JsonException("Path traverses non-object");
                }
                obj = obj.getAsObject().get((String)p);
            }
            if (!(p instanceof Integer)) continue;
            if (!obj.isArray()) {
                throw new JsonException("Path traverses non-array");
            }
            obj = obj.getAsArray().get((Integer)p);
        }
        return obj;
    }

    public static void main(String ... args) {
        JsonObject obj = new JsonObject();
        obj.put("x1", new JsonString("y"));
        obj.put("x2", JsonNumber.value(56L));
        obj.put("x2", JsonNumber.value(56L));
        JsonArray a = new JsonArray();
        a.add(JsonNumber.value(5L));
        a.add(new JsonBoolean(true));
        a.add(new JsonBoolean(false));
        obj.put("array", a);
        a = new JsonArray();
        a.add(JsonNumber.value(5L));
        obj.put("array2", a);
        obj.output(IndentedWriter.stdout);
        System.out.println();
        System.out.println(JsonAccess.access(obj, "x1"));
    }
}

