/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.web;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.sparql.graph.GraphFactory;
import com.hp.hpl.jena.sparql.resultset.ResultsFormat;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.riot.RiotReader;
import org.apache.jena.riot.lang.LangRIOT;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.riot.web.HttpCaptureResponse;
import org.apache.jena.riot.web.HttpResponseHandler;

public class HttpResponseLib {
    public static HttpResponseHandler httpDumpResponse = new HttpResponseHandler(){

        @Override
        public void handle(String contentType, String baseIRI, HttpResponse response) {
            try {
                int l;
                HttpEntity entity = response.getEntity();
                InputStream in = entity.getContent();
                byte[] buffer = new byte[1024];
                while ((l = in.read(buffer)) != -1) {
                    System.out.print(new String(buffer, 0, l, "UTF-8"));
                }
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
        }
    };
    public static HttpResponseHandler nullResponse = new HttpResponseHandler(){

        @Override
        public void handle(String contentType, String baseIRI, HttpResponse response) {
        }
    };
    public static HttpCaptureResponse<Graph> graphReaderTurtle = new AbstractGraphReader(){

        @Override
        protected LangRIOT createParser(InputStream in, String baseIRI, StreamRDF dest) {
            return RiotReader.createParserTurtle(in, baseIRI, dest);
        }
    };
    public static HttpCaptureResponse<Graph> graphReaderNTriples = new AbstractGraphReader(){

        @Override
        protected LangRIOT createParser(InputStream in, String baseIRI, StreamRDF dest) {
            return RiotReader.createParserNTriples(in, dest);
        }
    };
    public static HttpCaptureResponse<Graph> graphReaderRDFXML = new AbstractGraphReader(){

        @Override
        protected LangRIOT createParser(InputStream in, String baseIRI, StreamRDF dest) {
            return RiotReader.createParserRDFXML(in, baseIRI, dest);
        }
    };
    private static final Map<String, ResultsFormat> mapContentTypeToResultSet = new HashMap<String, ResultsFormat>();

    public static ResultsFormat contentTypeToResultSet(String contentType) {
        return mapContentTypeToResultSet.get(contentType);
    }

    static {
        mapContentTypeToResultSet.put("application/sparql-results+xml", ResultsFormat.FMT_RS_XML);
        mapContentTypeToResultSet.put("application/sparql-results+json", ResultsFormat.FMT_RS_JSON);
        mapContentTypeToResultSet.put("text/tab-separated-values", ResultsFormat.FMT_RS_TSV);
    }

    public static class HttpCaptureResponseResultSet
    implements HttpCaptureResponse<ResultSet> {
        ResultSet rs = null;

        @Override
        public void handle(String contentType, String baseIRI, HttpResponse response) throws IOException {
            MediaType mt = MediaType.create(contentType);
            ResultsFormat fmt = (ResultsFormat)mapContentTypeToResultSet.get(contentType);
            InputStream in = response.getEntity().getContent();
            this.rs = ResultSetFactory.load(in, fmt);
            this.rs = ResultSetFactory.copyResults(this.rs);
        }

        @Override
        public ResultSet get() {
            return this.rs;
        }
    }

    static abstract class AbstractGraphReader
    implements HttpCaptureResponse<Graph> {
        private Graph graph = null;

        AbstractGraphReader() {
        }

        @Override
        public final void handle(String contentType, String baseIRI, HttpResponse response) {
            try {
                Graph g = GraphFactory.createDefaultGraph();
                HttpEntity entity = response.getEntity();
                MediaType mt = MediaType.create(response.getFirstHeader("Content-Type").getValue());
                mt.getCharset();
                StreamRDF dest = StreamRDFLib.graph(g);
                InputStream in = entity.getContent();
                LangRIOT parser = this.createParser(in, baseIRI, dest);
                parser.parse();
                in.close();
                this.graph = g;
            }
            catch (IOException ex) {
                IO.exception(ex);
            }
        }

        @Override
        public Graph get() {
            return this.graph;
        }

        protected abstract LangRIOT createParser(InputStream var1, String var2, StreamRDF var3);
    }
}

