/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.ssh;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.ConnectionInfo;
import com.norbl.util.ssh.ConnectFailureException;
import com.norbl.util.ssh.ConstantsSSH;
import com.norbl.util.ssh.SshPingFailureException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;

public class Ssh {
    public static int N_MAX_RETRIES = 300;
    public static long RETRY_INTERVAL = 1000L;

    public static Connection connect(String hostname, String user, File pemFile, long maxWait) throws ConnectFailureException {
        ConnectFailureException cfx = null;
        IOException iox = null;
        long t0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t0 <= maxWait) {
            try {
                return Ssh.conAuth(hostname, user, pemFile);
            }
            catch (ConnectFailureException cx) {
                cfx = cx;
            }
            catch (IOException ix) {
                iox = ix;
            }
            try {
                Thread.sleep(RETRY_INTERVAL);
            }
            catch (InterruptedException ix) {}
        }
        String m = "";
        StackTraceElement[] stackTrace = new StackTraceElement[]{};
        if (cfx != null) {
            m = m + cfx.getMessage();
            stackTrace = cfx.getStackTrace();
        }
        if (iox != null) {
            m = m + "  " + iox.getMessage();
            stackTrace = iox.getStackTrace();
        }
        if (m.length() < 1) {
            m = m + " bad case: cfx and iox are null.";
        }
        ConnectFailureException x = new ConnectFailureException(m);
        x.setStackTrace(stackTrace);
        throw x;
    }

    private static Connection conAuth(String host, String user, File pemFile) throws IOException, ConnectFailureException {
        Connection c = null;
        try {
            c = new Connection(host);
            c.connect(null, ConstantsSSH.SSH_CONNECTION_TIMEOUT_MILLIS, ConstantsSSH.SSH_CONNECTION_TIMEOUT_MILLIS);
            if (!c.authenticateWithPublicKey(user, pemFile, null)) {
                c.close();
                throw new ConnectFailureException("Authorization failed connecting to " + user + "@" + host);
            }
            return c;
        }
        catch (IOException iox) {
            if (c != null) {
                c.close();
            }
            throw iox;
        }
    }

    private static Connection conAuth(String host, String user, String password) throws IOException, ConnectFailureException {
        Connection c = null;
        try {
            c = new Connection(host);
            c.connect(null, ConstantsSSH.SSH_CONNECTION_TIMEOUT_MILLIS, ConstantsSSH.SSH_CONNECTION_TIMEOUT_MILLIS);
            if (!c.authenticateWithPassword(user, password)) {
                c.close();
                throw new ConnectFailureException("Authorization failed connecting to " + user + "@" + host);
            }
            return c;
        }
        catch (IOException iox) {
            if (c != null) {
                c.close();
            }
            throw iox;
        }
    }

    public static HashMap<String, Connection> connect(List<String> hosts, String user, File pemFile, long maxWait) throws ConnectFailureException {
        HashMap<String, Connection> ht = new HashMap<String, Connection>();
        for (String h : hosts) {
            ht.put(h, Ssh.connect(h, user, pemFile, maxWait));
        }
        return ht;
    }

    public static HashMap<String, Connection> connect(List<String> hosts, String user, File pemFile, long maxWait, long maxTotalWait) throws ConnectFailureException {
        ConnectFailureException cx = null;
        long t0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t0 < maxTotalWait) {
            try {
                return Ssh.connect(hosts, user, pemFile, maxWait);
            }
            catch (ConnectFailureException cfx) {
                cx = cfx;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ix) {}
            }
        }
        if (cx != null) {
            throw cx;
        }
        return null;
    }

    public static void closeConnections(HashMap<String, Connection> ht) {
        for (String k : ht.keySet()) {
            Connection c = ht.get(k);
            if (c == null) continue;
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pingSsh(String host) {
        Connection c = null;
        try {
            c = new Connection(host);
            ConnectionInfo ci = c.connect(null, ConstantsSSH.SSH_CONNECTION_TIMEOUT_MILLIS, ConstantsSSH.SSH_CONNECTION_TIMEOUT_MILLIS);
            boolean bl = true;
            return bl;
        }
        catch (Exception iox) {
            if (c != null) {
                c.close();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (c != null) {
                c.close();
            }
        }
    }

    public static void waitForPingSsh(String host, long maxWaitMillis) throws SshPingFailureException {
        long t0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t0 <= maxWaitMillis) {
            if (Ssh.pingSsh(host)) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ix) {}
        }
        throw new SshPingFailureException("Util.waitForPingSsh() timed out attempting to  reach " + host);
    }
}

