\name{rriskMLEdist}
\alias{rriskMLEdist}
\title{Maximum likelihood fitting of univariate distributions}
\usage{
  rriskMLEdist(data, distr, start = NULL, optim.method =
    "default", lower = -Inf, upper = Inf, custom.optim =
    NULL, ...)
}
\arguments{
  \item{data}{A numerical vector for non censored data or a
  dataframe of two columns respectively named left and
  right, describing each observed value as an interval for
  censored data. In that case the left column contains
  either NA for left censored observations, the left bound
  of the interval for interval censored observations, or
  the observed value for non-censored observations. The
  right column contains either NA for right censored
  observations, the right bound of the interval for
  interval censored observations, or the observed value for
  non-censored observations.}

  \item{distr}{A character string "name" naming a
  distribution (or directly the density function) for which
  the corresponding density function dname and the
  corresponding distribution pname must be classically
  defined. The possible values are: "norm", "exp", "lnorm",
  "logis", "gamma", "weibull", "beta", "chisq", "t", "f",
  "cauchy", "gompertz".}

  \item{start}{A named list giving the initial values of
  parameters of the named distribution. This argument may
  be omitted for some distributions for which reasonable
  starting values are computed (see details).}

  \item{optim.method}{"default" (see details) or
  optimization method to pass to \code{optim}.}

  \item{lower}{Left bounds on the parameters for the
  "L-BFGS-B" method (see \code{optim}).}

  \item{upper}{Right bounds on the parameters for the
  "L-BFGS-B" method (see \code{optim}).}

  \item{custom.optim}{a function carrying the MLE
  optimization (see details).}

  \item{...}{further arguments passed to the \code{optim}
  or \code{custom.optim} function.}
}
\value{
  \code{rriskMLEdist} returns a list with fitting results
  containing following informations
  \item{\code{estimate}}{numeric, a single value or a
  vector containing estimated parameters.}
  \item{\code{convergence}}{an integer code for the
  convergence of \code{optim}. The value \code{0} indicates
  a successful convergence.} \item{\code{loglik}}{the
  log-likelihood} \item{\code{hessian}}{a symmetric matrix
  computed by \code{optim} as an estimate of the Hessian at
  the solution found or computed in the user-supplied
  optimization function. It is used in
  \code{rriskFitdist.cont} to estimate standard errors.}
  \item{\code{optim.function}}{the name of the optimization
  function used for maximum likelihood.}
}
\description{
  Fits a univariate distribution by maximum likelihood.
}
\details{
  This function is an alias of the function \code{mledist}
  from the package \pkg{fitdistrplus} (Version 0.1-2). The
  original function was extended to fitting additional
  distributions. The following continuous distributions can
  be fitted by this function: normal, exponential,
  lognormal, logistic, gamma, Weibull, Beta, chi-square,
  Student's t, F, Cauchy, Gompertz and triangular. And the
  following discrete distributions can be fitted: (wird
  ergaenzt). \cr \cr For more details see the assistance
  page of the function \code{mledist} from the package
  \pkg{fitdistrplus}. \cr \cr This function is not intended
  to be called directly but is internally called in
  \code{rriskFitdist.cont}.
}
\examples{
\donttest{
# a basic fit of some distribution with maximum likelihood estimation
set.seed(1)
x2<-rchisq(500,4)
rriskMLEdist(x2,"norm")
rriskMLEdist(x2,"exp")
rriskMLEdist(x2,"lnorm")
rriskMLEdist(x2,"logis")
rriskMLEdist(x2,"gamma")
rriskMLEdist(x2,"weibull")
rriskMLEdist(x2,"beta")
rriskMLEdist(x2,"chisq")
rriskMLEdist(x2,"t")
rriskMLEdist(x2,"f")
rriskMLEdist(x2,"cauchy")
rriskMLEdist(x2,"gompertz")
#rriskMLEdist(x2,"triang")}
}
\author{
  Matthias Greiner \email{matthias.greiner@bfr.bund.de}
  (BfR), \cr Kristin Tolksdorf
  \email{kristin.tolksdorf@bfr.bund.de} (BfR), \cr
  Katharina Schueller \email{schueller@stat-up.de}
  (\acronym{STAT-UP} Statistical Consulting), \cr Natalia
  Belgorodski \email{belgorodski@stat-up.de}
  (\acronym{STAT-UP} Statistical Consulting), \cr
  Marie-Laure Delignette-Muller (coauthor of the package
  \pkg{fitdistrplus}), \cr Christophe Dutang (coauthor of
  the package \pkg{fitdistrplus})
}
\keyword{fitdistrplus}

