% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/satTime.R
\name{satTime}
\alias{satTime}
\title{satTime}
\usage{
satTime(o.time = o.time, t.var = t.var)
}
\arguments{
\item{o.time}{Object of class \emph{Date}.}

\item{t.var}{Target variable.}
}
\value{
One or multiple plots.
}
\description{
Finds available satellite dates for tracking data.
}
\details{
{This function compares a set of input dates (\emph{o.time}) to the possible dates for
which satellite data can be downloaded. This analysis is performed for the set of variables
provided through the function proSat(). The function provides a report with the closest dates
available for each of the samples and a faceted plot for each unique year showing the observed
dates, the dates covered by the satellite data and the dates covered by both.}
}
\examples{
{

 # return list of variables
 var.ls <- satTime(o.time=as.Date("2013-08-04"), t.var="ndvi")

}
}
\seealso{
\code{\link{moveCloud}} \code{\link{proSat}}
}
