% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apparent.R
\name{apparent}
\alias{apparent}
\title{Sampling for the Apparent Error Rate}
\usage{
apparent(data, ...)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Not currently used.}
}
\value{
An tibble with a single row and classes `apparent`, 
  `rset`, `tbl_df`, `tbl`, and `data.frame`. The 
  results include a column for the data split objects and one column 
  called `id` that has a character string with the resample identifier.
}
\description{
When building a model on a data set and re-predicting the same data, the
  performance estimate from those predictions is often call the 
  "apparent" performance of the model. This estimate can be wildly 
  optimistic. "Apparent sampling" here means that the analysis and 
  assessment samples are the same. These resamples are sometimes used in 
  the analysis of bootstrap samples and should otherwise be
  avoided like ol sushi.
}
\examples{
apparent(mtcars)
}
