% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation_split.R
\name{validation_split}
\alias{validation_split}
\title{Create a Validation Set}
\usage{
validation_split(data, prop = 3/4, strata = NULL, breaks = 4, ...)
}
\arguments{
\item{data}{A data frame.}

\item{prop}{The proportion of data to be retained for modeling/analysis.}

\item{strata}{A variable that is used to conduct stratified sampling to
create the resamples. This could be a single character value or a variable
name that corresponds to a variable that exists in the data frame.}

\item{breaks}{A single number giving the number of bins desired to stratify
a numeric stratification variable.}

\item{...}{Not currently used.}
}
\value{
An tibble with classes \code{validation_split}, \code{rset}, \code{tbl_df}, \code{tbl},
and \code{data.frame}. The results include a column for the data split objects
and a column called \code{id} that has a character string with the resample
identifier.
}
\description{
\code{validation_split()} takes a single random sample (without replacement) of
the original data set to be used for analysis. All other data points are
added to the assessment set (to be used as the validation set).
}
\details{
The \code{strata} argument causes the random sampling to be conducted
\emph{within the stratification variable}. This can help ensure that the number of
data points in the analysis data is equivalent to the proportions in the
original data set.
}
\examples{
validation_split(iris, prop = .9)
}
