% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalaSBT.R
\name{scalaSBT}
\alias{scalaSBT}
\title{Run SBT and Deploy JAR Files}
\usage{
scalaSBT(args = c("+package", "packageSrc"), copy.to.package = TRUE,
  only.if.newer = TRUE)
}
\arguments{
\item{args}{A character vector giving the arguments to be passed to the SBT
command.}

\item{copy.to.package}{Should the JARs files be copied to the appropriate
directories of the R package source?'}

\item{only.if.newer}{Should compilation be avoided if it appears Scala code
has not changed?}
}
\value{
\code{NULL}
}
\description{
This function runs SBT (Scala Build Tool) to package JAR files and then copy
them to the appropriate directories of the R package source.
}
\details{
Starting from the current working directory and moving up the file system
hierarchy as needed, this function searches for the directory containing the
file \code{'build.sbt'}, the SBT build file. It temporarily changes the
working directory to this directory. It then runs \code{sbt +package
packageSrc} to package the cross-compiled the Scala code and package the
source code. publish the JAR files locally. Finally, it copies the JAR files
to the appropriate directories of the R package source. Specifically, source
JAR files go into \code{(PKGHOME)/java} and binary JAR files go into
\code{(PKGHOME)/inst/java/scala-(VERSION)}, where \code{(PKGHOME)} is the
package home and \code{(VERSION)} is the major Scala version (e.g., 2.13). It
is assumed that the package home is a subdirectory of the directory
containing the \code{'build.sbt'} file.

Note that SBT may give weird errors about not being able to download needed
dependences.  The issue is that some OpenJDK builds less than version 10 do
not include root certificates.  The solution is to either: i. manually
install OpenJDK version 10 or greater, or ii. manually install Oracle's
version of Java. Both are capable with the rscala package.
}
