% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scalaPushRegister.R
\name{scalaPushRegister}
\alias{scalaPushRegister}
\alias{scalaPullRegister}
\title{Register Functions to Push and Pull Between R and Scala}
\usage{
scalaPushRegister(pusher, method, bridge = scalaFindBridge())

scalaPullRegister(puller, method, bridge = scalaFindBridge())
}
\arguments{
\item{pusher}{A function whose first two arguments are as shown in the example below.
Other arguments can be used as additional arguments.}

\item{method}{A string giving the name of the specific 'push' or 'pull' method.}

\item{bridge}{An rscala bridge.}

\item{puller}{A function whose first two arguments are as shown in the example below.
Other arguments can be used as additional arguments.}
}
\description{
The 'rscala' package provides support for serializing objects between R and Scala.
These registration functions allows
additional, more-specialized push and pull methods to be added.
Package developers may want to call these registration functions in the package's
\code{\link{.onLoad}} function.
}
\examples{
\donttest{
s <- scala()

name <- "Grace"
nameAsRObject <- scalaPush(name,"generic")   # Basic serialization
scalaType(nameAsRObject)
identical(name,scalaPull(nameAsRObject,"generic"))

scalaPush.character <- function(x, bridge) {
  if ( is.character(x) && ( length(x) == 1L ) ) bridge(x=x) ^ 'x'
  else stop("'x' should be a character vector.")
}
scalaPushRegister(scalaPush.character, "character")
nameAsString <- scalaPush(name, "character", s)    # More specific serialization
scalaType(nameAsString)

scalaPull.character <- function(reference, bridge) {
  if ( scalaType(reference) == "String" ) reference$toString()
  else stop("'reference' should be a 'String'.")
}
scalaPullRegister(scalaPull.character, "character")
identical(name,scalaPull(nameAsString,"character"))

close(s)
}

}
\seealso{
\code{\link{scalaPush}}, \code{\link{scalaPull}}
}
