% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_article.R
\name{get_article}
\alias{get_article}
\title{Scrape text from a single article hosted on Scielo}
\usage{
get_article(x, output_text = TRUE)
}
\arguments{
\item{x}{a character vector with the link or id of the article hosted on
Scielo to be scrapped.}

\item{output_text}{a logical indicating whether \code{get_article()} should return
a \code{character} vector or a \code{tibble} (defaults to \code{TRUE}).}
}
\value{
When the argument \code{output_text} is \code{TRUE}, the function returns
a \code{character} vector with the requested article's content. When \code{output_text}
is \code{FALSE}, the function returns a \code{tibble} with the following variables:

\itemize{
  \item text: article's full text (\code{character}).
  \item doi: article's Digital Object Identifier (DOI, (\code{character})).
}
}
\description{
\code{get_article()} scrapes the full text from an article hosted on Scielo.
In bilingual journals, the text retrieved is in the journal's main language
 used for publication (most of the time, it is English).
}
\note{
Sometimes, the Scielo website is offline for maintaince,
in which cases this function will not work (i.e., users will get HTML status
different from the usual 200 OK).
}
\examples{
\donttest{
article <- get_article(x = "http://www.scielo.br/scielo.php?
script=sci_arttext&pid=S1981-38212016000200201&lng=en&nrm=iso&tlng=en")
}
}
