% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servers.R
\name{servers}
\alias{servers}
\alias{discoverServers}
\alias{addConnectServer}
\alias{addServer}
\alias{removeServer}
\alias{serverInfo}
\alias{addServerCertificate}
\title{Server Management Functions}
\usage{
servers(local = FALSE)

discoverServers(quiet = FALSE)

addConnectServer(url, name = NULL, certificate = NULL, quiet = FALSE)

addServer(url, name = NULL, certificate = NULL, quiet = FALSE)

removeServer(name)

serverInfo(name)

addServerCertificate(name, certificate, quiet = FALSE)
}
\arguments{
\item{local}{Return only local servers (i.e. not \code{shinyapps.io})}

\item{quiet}{Suppress output and prompts where possible.}

\item{url}{Server's URL. Should look like \code{http://servername/} or
\code{http://servername:port/}.}

\item{name}{Optional nickname for the server. If none is given, the nickname
is inferred from the server's hostname.}

\item{certificate}{Optional; a path a certificate file to be used when making
SSL connections to the server. The file's contents are copied and stored by
the \pkg{rsconnect} package. Can also be a character vector containing the
certificate's contents.}
}
\value{
\code{servers} returns a data frame with registered server names and URLs.
\code{serverInfo} returns a list with details for a particular server.
}
\description{
Functions to manage the list of known servers to which
\pkg{rsconnect} can deploy and manage applications.
}
\details{
Register a server with \code{addServer} or \code{discoverServers} (the latter
is useful only if your administrator has configured server autodiscovery).
Once a server is registered, you can connect to an account on the server
using \code{\link{connectUser}}.

The \code{servers} and \code{serverInfo} functions are provided for viewing
previously registered servers.

There is always at least one server registered (the \code{shinyapps.io}
server)
}
\examples{
\dontrun{

# register a local server
addServer("http://myrsconnect/", "myserver")

# list servers
servers(local = TRUE)

# connect to an account on the server
connectUser(server = "myserver")
}
}
