% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rscontract_spec.R
\name{rscontract_spec}
\alias{rscontract_spec}
\title{A flexible API that can be converted to an RStudio Connection Contract}
\usage{
rscontract_spec(connection_object = NULL, type = "spec_type",
  host = "spec_host", icon = NULL, name = "",
  connect_script = "library(connections)\\n[Place your code here]",
  disconnect_code = "function() rscontract_close('spec_host', 'spec_type')",
  preview_code = "function(){}", catalog_list = "sample_catalog()",
  object_types = "default_types()", object_list = NULL,
  object_columns = NULL, actions = NULL)
}
\arguments{
\item{connection_object}{The connection object. Default to NULL.}

\item{type}{Type of the connection.}

\item{host}{Name of the host}

\item{icon}{Path to the connection's icon. Defaults to NULL.}

\item{name}{The connection's name.}

\item{connect_script}{The text of the connection code.}

\item{disconnect_code}{Function to use to disconnect. Default to function(){}.}

\item{preview_code}{Function to run when the preview table icon is clicked on. Default to function(){}.}

\item{catalog_list}{Hierarchical list of the catalogs, schema, table/view and fields.}

\item{object_types}{Function that provides the structure of the connection.
The default function will work properly, it is going to be rare when it needs to be changed.}

\item{object_list}{Function to run to get the catalogs, schema, tables or views based what has been
expanded on. Defaults to NULL.}

\item{object_columns}{Function to run that pull the field information. Default to NULL}

\item{actions}{Additional buttons to add to the connection pane. Defaults to NULL.}
}
\value{
Returns an `rscontract_spec` class object
}
\description{
A flexible API that can be converted to an RStudio Connection Contract
}
\examples{

str(rscontract_spec())

}
