% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_functions.R
\name{landsat_mask_function}
\alias{landsat_mask_function}
\title{Create a Landsat mask raster from the QA band}
\usage{
landsat_mask_function(raster)
}
\arguments{
\item{raster}{The QA band of a Landsat image}
}
\value{
A boolean raster to be used to mask a Landsat image
}
\description{
Create a Landsat mask raster from the QA band
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
aoi <- sf::st_point(c(-74.912131, 44.080410))
aoi <- sf::st_set_crs(sf::st_sfc(aoi), 4326)
aoi <- sf::st_buffer(sf::st_transform(aoi, 5070), 100)

landsat_image <- get_landsat_imagery(
  aoi,
  start_date = "2022-06-01",
  end_date = "2022-08-30",
  mask_function = landsat_mask_function
)
\dontshow{\}) # examplesIf}
}
