% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisimsum.R
\name{multisimsum}
\alias{multisimsum}
\title{Analyses of simulation studies with multiple estimands at once, including Monte Carlo error}
\usage{
multisimsum(data, par, true, estvarname, se, methodvar = NULL, ref = NULL,
  df = NULL, dropbig = FALSE, max = 10, semax = 100, level = 0.95,
  by = NULL, mcse = TRUE, sanitise = TRUE, na.rm = TRUE,
  na.pair = TRUE)
}
\arguments{
\item{data}{A \code{data.frame} in which variable names are interpreted. It has to be in tidy format, e.g. each variable forms a column and each observation forms a row.}

\item{par}{The name of the variable containing the methods to compare. Can be \code{NULL}.}

\item{true}{The true value of the parameter. This is used in calculations of bias and coverage.}

\item{estvarname}{The name of the variable containing the point estimates.}

\item{se}{The name of the variable containing the standard errors of the point estimates.}

\item{methodvar}{The name of the variable containing the methods to compare. Can be \code{NULL}.}

\item{ref}{Specifies the reference method against which relative precision will be calculated. Only useful if \code{methodvar} is specified.}

\item{df}{If specified, a t distribution with \code{df} degrees of freedom is used when calculating coverage and power.}

\item{dropbig}{Specifies that point estimates or standard errors beyond the maximum acceptable values should be dropped.}

\item{max}{Specifies the maximum acceptable absolute value of the point estimates, standardised to mean 0 and SD 1. Defaults to \code{10}.}

\item{semax}{Specifies the maximum acceptable value of the standard error, as a multiple of the mean standard error. Defaults to \code{100}.}

\item{level}{Specifies the confidence level for coverage and power. Defaults to \code{0.95}.}

\item{by}{A vector of variable names to compute performance measures by a list of factors. Can be \code{NULL}.}

\item{mcse}{Reports Monte Carlo standard errors for all performance measures. Defaults to \code{TRUE}.}

\item{sanitise}{Sanitise column names passed to \code{simsum} by removing all dot characters (\code{.}), which could cause problems. Defaults to \code{TRUE}.}

\item{na.rm}{A logical value indicating whether missing values (\code{NA}) should be removed before the computation proceeds. Defaults to \code{TRUE}.}

\item{na.pair}{Removes estimates that have a missing standard error (and vice versa). Defaults to \code{TRUE}.}
}
\value{
An object of class \code{multisimsum}.
}
\description{
\code{multisimsum} is an extension of \code{\link[=simsum]{simsum()}} that can handle multiple estimated parameters at once. \code{multisimsum} calls \code{\link[=simsum]{simsum()}} internally, each estimands at once. There is only one new argument that must be set when calling \code{multisimsum}: \code{par}, a string representing the column of \code{data} that identifies the different estimands.
}
\details{
multisimsum
}
\examples{
data(frailty)
ms <- multisimsum(data = frailty, par = "par", true = c(trt = -0.50,
   fv = 0.75), estvarname = "b", se = "se", methodvar = "model",
   by = "fv_dist")
ms
}
