% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.summary.simsum.R
\name{autoplot.summary.simsum}
\alias{autoplot.summary.simsum}
\title{autoplot method for summary.simsum objects}
\usage{
\method{autoplot}{summary.simsum}(
  object,
  type = "forest",
  stats = "nsim",
  target = NULL,
  fitted = TRUE,
  scales = "fixed",
  top = TRUE,
  density.legend = TRUE,
  zoom = 1,
  ...
)
}
\arguments{
\item{object}{An object of class \code{summary.simsum}.}

\item{type}{The type of the plot to be produced. Possible choices are: \code{forest}, \code{lolly}, \code{zip}, \code{est}, \code{se}, \code{est_ba}, \code{se_ba}, \code{est_ridge}, \code{se_ridge}, \code{est_density}, \code{se_density}, \code{est_hex}, \code{se_hex}, \code{heat}, \code{nlp}, with \code{forest} being the default.}

\item{stats}{Summary statistic to plot, defaults to \code{nsim} (the number of replications with non-missing point estimates/SEs).
See \code{\link[=summary.simsum]{summary.simsum()}} for further details on supported summary statistics.}

\item{target}{Target of summary statistic, e.g. 0 for \code{bias}. Defaults to \code{NULL}, in which case target will be inferred.}

\item{fitted}{Superimpose a fitted regression line, useful when \code{type} = (\code{est}, \code{se}, \code{est_ba}, \code{se_ba}, \code{est_density}, \code{se_density}, \code{est_hex}, \code{se_hex}). Defaults to \code{TRUE}.}

\item{scales}{Should scales be fixed (\code{fixed}, the default), free (\code{free}), or free in one dimension (\code{free_x}, \code{free_y})?}

\item{top}{Should the legend for a nested loop plot be on the top side of the plot? Defaults to \code{TRUE}.}

\item{density.legend}{Should the legend for density and hexbin plots be included? Defaults to \code{TRUE}.}

\item{zoom}{A numeric value between 0 and 1 signalling that a zip plot should \emph{zoom} on the top x\% of the plot (to ease interpretation). Defaults to 1, where the whole zip plot is displayed.}

\item{...}{Not used.}
}
\value{
A \code{ggplot} object.
}
\description{
autoplot method for summary.simsum objects
}
\examples{
data("MIsim", package = "rsimsum")
s <- rsimsum::simsum(
  data = MIsim, estvarname = "b", true = 0.5, se = "se",
  methodvar = "method", x = TRUE
)
ss <- summary(s)

library(ggplot2)
autoplot(ss)
autoplot(ss, type = "lolly")
}
