% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{ckappa}
\alias{ckappa}
\title{Computes Cohen's Kappa for agreement in the case of 2 raters.}
\usage{
ckappa(observed, predicted)
}
\arguments{
\item{observed}{The vector of observed values (truth).}

\item{predicted}{The vector of predicted values.}
}
\description{
Cohen’s kappa coefficient value is a robust statistical measure of inter-rater agreement published in 1960 by Jacob Cohen. It has been reused by numerous studies in sleep medicine to measure the accuracy of predictions, especially for automatic sleep staging.
}
\examples{
observed = c("AWA", "N1", "N2", "N3", "REM")
predicted = c("AWA", "AWA", "N2", "N3", "REM")
ckappa(observed, predicted)
}
\references{
Cohen J. A Coefficient of Agreement for Nominal Scales. Educational and Psychological Measurement. 1960;20:37-46.
}
