% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eeg.R
\name{pwelch}
\alias{pwelch}
\title{Power spectral density using Welch's method.}
\usage{
pwelch(x, sRate, points = 0, overlap = 0, padding = 0)
}
\arguments{
\item{x}{Signal vector.}

\item{sRate}{Sample rate of the signal.}

\item{points}{Number of samples.}

\item{overlap}{Windows overlap.}

\item{padding}{Windows padding.}
}
\value{
A raw periodogram dataframe.
}
\description{
Power spectral density using Welch's method.
}
\examples{
x <- sin(c(1:10000))
psd <- pwelch(sin(c(1:10000)), 200)
head(psd)
}
\references{
Welch, P. “The Use of Fast Fourier Transform for the Estimation of Power Spectra: A Method Based on Time Averaging over Short, Modified Periodograms.” IEEE Transactions on Audio and Electroacoustics 15, no. 2 (June 1967): 70–73. https://doi.org/10.1109/TAU.1967.1161901.
}
