% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{transitions}
\alias{transitions}
\title{Compute a matrix of stages transitions counts.}
\usage{
transitions(
  hypnogram,
  stages = c("AWA", "REM", "N1", "N2", "N3"),
  plot = FALSE
)
}
\arguments{
\item{hypnogram}{A hypnogram dataframe. Dataframe must contain \code{begin} (\code{POSIXt}), \code{end} (\code{POSIXt}) and \code{event} (\code{character}) columns.}

\item{stages}{Stages to include in transitions Defaults to \code{c("N1", "N2", "N3", "N4", "REM")}.}

\item{plot}{Plot the transition matrix or not. Takes \code{"heatmap"} to plot a heatmap of transitions or \code{FALSE} to return the matrix as a dataframe without plotting it.}
}
\value{
A matrix with count of stages transitions, or a plot.
}
\description{
Compute a matrix of stages transitions counts.
}
\examples{
download.file("https://rsleep.org/data/hypnodensity.csv", "hypnodensity.csv")

hypnodensity <- read.csv2("hypnodensity.csv")

unlink("hypnodensity.csv")

events <- hypnogram(hypnodensity)

transitions(events, plot = "heatmap")
}
