\name{djoin}

\alias{djoin}
\alias{stdorder}

\title{Join designs together into a blocked design}
\description{
This implements the \pkg{rsm} package's building-block provisions for handling
sequences of experiments. We often want to join two or more designs into one blocked design for purposes of analysis.
}
\usage{
djoin(design1, design2, \dots, blkname = "Block", blocklev)
stdorder(design)
}
\arguments{
  \item{design1}{A \code{coded.data} object (must have been created by \pkg{rsm} 2.00 or higher).}
  \item{design2}{A \code{data.frame} (or \code{coded.data}) to be appended; 
    or a call to a function that will create a design}
\item{\dots}{Additional designs to be appended}
\item{blkname}{Name to give to the blocking variable that distinguishes the designs that are joined}
\item{blocklev}{Label to use in the blocking variable for the added design}
\item{design}{A \code{coded.data} object to be displayed.}
}
\details{
\code{djoin} may be used to augment a design with all manner of other designs, including regular designs generated by \code{\link{cube}} and its relatives, \code{data.frames}, and other \code{coded.data} objects. The underlying paradigm is that each design joined is a separate block, and the order in which they are joined could matter. 

It tries to do this in a smart way: The first design, \code{design1}, is required to be a \code{\link{coded.data}} object. If \code{design2} is a \code{\link{data.frame}}, and variables with the coded names are not present, it is automatically coded according to \code{design1}'s coding formulas. If \code{design2} is a \code{coded.data} object, and its coding formulas differ from those of \code{design1}, then \code{design1} is recoded with \code{design2}'s codings before the designs are joined. In both cases, any variables in \code{design2} not matched in \code{design1} are excluded, and any \code{design1} variables absent in \code{design2} are added with values of \code{NA}.
}

\value{
\code{djoin} returns a \code{\link{coded.data}} object with the combined designs, and coding formulas from the last \code{coded.data} object added. The generated blocking variable will be a \code{\link{factor}}. The designs are sorted by blocks and \code{run.order} within blocks; and its \code{row.names} will be integers corresponding to this ordering. 

The function \code{stdorder} sorts such data by block and \code{std.order} within block to display the designs in their pre-randomized order.
}

\author{Russell V. Lenth}

\seealso{\code{\link{cube}}, \code{\link{coded.data}}, \code{\link{bbd}}}
\examples{
# Some existing data
CR1 <- coded.data(ChemReact1, x1 ~ (Time - 85)/5, x2 ~ (Temp - 175)/5)
# add the second part of the experiment; it gets coded automagically
djoin(CR1, ChemReact2)

# A new experiment in a different part of the design space
newdes <- cube(Yield ~ x1 + x2,  n0 = 3, 
    coding = c(x1 ~ (Time - 70)/10, x2 ~ (Temp - 180)/5))
# Time passes ... we do the experiment and plug-in the observed Yield values
newdes$Yield <- rnorm(7, 75, 3) # these are our pretend results
combined <- djoin(CR1, newdes)
# Observe that the combined dataset is recoded to the new formulas
print(combined, decode = FALSE)

# List the new design in standard order
stdorder(newdes)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{design}
