% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdtodoc.R
\name{document_append_from_html}
\alias{document_append_from_html}
\title{Add html content to an existing RSpace document}
\usage{
document_append_from_html(
  path,
  existing_document_id,
  tags = NULL,
  attachments = NULL,
  allow_missing_fields = FALSE,
  api_key = get_api_key()
)
}
\arguments{
\item{path}{html document to upload}

\item{existing_document_id}{document identifier of the current RSpace document.}

\item{tags}{vector of tags to apply to the document (will include "rspacer" by default)}

\item{attachments}{attachments to attach to the fields in tibble/data.frame form (one attachment per row), e.g., \code{tibble(field = 7, path = "file.txt")}}

\item{allow_missing_fields}{Specify if a mismatch in fields is allowed.
If this is \code{FALSE}, the html fields cannot be appended to the RSpace document when fields are missing.
If it is \code{TRUE}, only fields with the same name as in the template will be appended.}

\item{api_key}{RSpace API key}
}
\value{
Invisible JSON response from the API.
}
\description{
Append a html document (e.g., generated from quarto) to an RSpace structured document.
This function retrieves the current document, and adds text to fields specified by
h2 html headers.
}
