% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{items_reap}
\alias{items_reap}
\title{Utility functions}
\usage{
items_reap(items, ..., field = NULL)
}
\arguments{
\item{items}{a \code{STACItemCollection} object representing
the result of \code{/stac/search}, \code{/collections/{collectionId}/items}.}

\item{...}{a named way to provide fields names to get the
subfields values from the \code{RSTACDocument} objects.}

\item{field}{a \code{character} with the names of the field to
get the subfields values from the \code{RSTACDocument} objects.}
}
\value{
a \code{vector} if the supplied field is atomic, or a list if not.
}
\description{
This function returns the values of a field of the
 \code{STACItemCollections} object. If the values of the specified field are
 not atomic the return will be in list form, if they are, it will be returned
 in vector form.
}
\examples{
\donttest{
# STACItemCollection object
stac_item <- stac("http://brazildatacube.dpi.inpe.br/stac/") \%>\%
 stac_search(collections = "CB4_64_16D_STK-1", limit = 100,
        datetime = "2017-08-01/2018-03-01",
        bbox = c(-48.206,-14.195,-45.067,-12.272)) \%>\%
 get_request() \%>\% items_fetch(progress = FALSE)

stac_item \%>\% items_reap(field = c("properties", "datetime"))
}

}
