% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stac_search.R
\name{stac_search}
\alias{stac_search}
\title{Endpoint functions}
\usage{
stac_search(
  q,
  collections = NULL,
  ids = NULL,
  bbox = NULL,
  datetime = NULL,
  intersects = NULL,
  limit = NULL
)
}
\arguments{
\item{q}{a \code{RSTACQuery} object expressing a STAC query
criteria.}

\item{collections}{a \code{character} vector of collection IDs to include in
the search for items. Only items in one of the provided collections will be
searched.}

\item{ids}{a \code{character} vector with item IDs. All other filters
parameters that further restrict the number of search results are ignored.}

\item{bbox}{a \code{numeric} vector with only features that have a
geometry that intersects the bounding box are selected. The bounding box is
provided as four or six numbers, depending on whether the coordinate
reference system includes a vertical axis (elevation or depth):
\itemize{ \item Lower left corner, coordinate axis 1
\item Lower left corner, coordinate axis 2
\item Lower left corner, coordinate axis 3 (optional)
\item Upper right corner, coordinate axis 1
\item Upper right corner, coordinate axis 2
\item Upper right corner, coordinate axis 3 (optional) }

The coordinate reference system of the values is WGS84 longitude/latitude
(\url{http://www.opengis.net/def/crs/OGC/1.3/CRS84}). The values are, in
most cases, the sequence of minimum longitude, minimum latitude, maximum
longitude, and maximum latitude. However, in cases where the box spans the
antimeridian, the first value (west-most box edge) is larger than the third
value (east-most box edge).}

\item{datetime}{a \code{character} with a date-time or an interval. Date
and time strings needs to conform to RFC 3339. Intervals are expressed by
separating two date-time strings by \code{'/'} character. Open intervals are
expressed by using \code{'..'} in place of date-time.

Examples:
\itemize{
\item A date-time: \code{"2018-02-12T23:20:50Z"}
\item A closed interval: \code{"2018-02-12T00:00:00Z/2018-03-18T12:31:12Z"}
\item Open intervals: \code{"2018-02-12T00:00:00Z/.."} or
\code{"../2018-03-18T12:31:12Z"}
}

Only features that have a \code{datetime} property that intersects the
interval or date-time informed in \code{datetime} are selected.}

\item{intersects}{a \code{list} expressing GeoJSON geometries
objects as specified in RFC 7946. Only returns items that intersect with
the provided geometry. To turn a GeoJSON into a list the packages
\code{geojsonsf} or \code{jsonlite} can be used.}

\item{limit}{an \code{integer} defining the maximum number of results
to return. If not informed, it defaults to the service implementation.}
}
\value{
A \code{RSTACQuery} object with the subclass \code{search} containing all
search field parameters to be provided to STAC API web service.
}
\description{
(This document is based on STAC specification documentation
\url{https://github.com/radiantearth/stac-spec/}
and reproduces some of its parts)

The \code{stac_search} function implements \verb{/stac/search} API endpoint
(v0.8.1) and \verb{/search} (v0.9.0 or v1.0.0).
It prepares query parameters used in the search API request, a
\code{stac} object with all filter parameters to be provided to
\code{get_request} or \code{post_request} functions. The GeoJSON content
returned by these requests is a \code{STACItemCollection} object, a regular R
\code{list} representing a STAC Item Collection document.
}
\examples{
\dontrun{
 # GET request
 stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
  stac_search(collections = "CB4_64_16D_STK-1", limit = 10,
         datetime = "2017-08-01/2018-03-01") \%>\%
  get_request()

 # POST request
 stac("https://brazildatacube.dpi.inpe.br/stac/") \%>\%
  stac_search(collections = "CB4_64_16D_STK-1",
         bbox = c(-47.02148, -17.35063, -42.53906, -12.98314)) \%>\%
  post_request()
}

}
\seealso{
\code{\link[=stac]{stac()}}, \code{\link[=ext_query]{ext_query()}},
\code{\link[=get_request]{get_request()}}, \code{\link[=post_request]{post_request()}}
}
