% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{rstanarm-plots}
\alias{rstanarm-plots}
\title{Plots for rstanarm models}
\description{
Models fit using \code{algorithm='sampling'}, \code{"meanfield"}, or
\code{"fullrank"} are compatible with a variety of plotting functions from
the \pkg{rstan} package. Each function returns at least one
\code{\link[ggplot2]{ggplot}} object that can be customized further using the
\pkg{ggplot2} package. The plotting functions described here can be called
using the \code{\link[=plot.stanreg]{plot method}} for stanreg objects 
without loading the \pkg{rstan} package. For example usage see 
\code{\link{plot.stanreg}}.
}
\section{Plotting functions}{


\describe{
\item{Posterior intervals and point
estimates}{\code{\link[rstan]{stan_plot}}}
\item{Traceplots}{\code{\link[rstan]{stan_trace}}}
\item{Histograms}{\code{\link[rstan]{stan_hist}}}
\item{Kernel density estimates}{\code{\link[rstan]{stan_dens}}}
\item{Scatterplots}{\code{\link[rstan]{stan_scat}}}
\item{Diagnostics for Hamiltonian Monte Carlo and the No-U-Turn
Sampler}{\code{\link[rstan]{stan_diag}}}
\item{Rhat}{\code{\link[rstan]{stan_rhat}}}
\item{Ratio of effective sample size to total posterior sample
size}{\code{\link[rstan]{stan_ess}}}
\item{Ratio of Monte Carlo standard error to posterior standard
deviation}{\code{\link[rstan]{stan_mcse}}}
\item{Autocorrelation}{\code{\link[rstan]{stan_ac}}}
}
}
\examples{
# See examples at help("plot.stanreg", package = "rstanarm")
}
\seealso{
\code{\link{plot.stanreg}} for how to call the \code{plot} method, 
  \code{\link{shinystan}} for interactive model exploration,
  \code{\link{pp_check}} for graphical posterior predicive checking.
}

