% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print-and-summary.R
\name{print.stanreg}
\alias{print.stanreg}
\title{Print method for stanreg objects}
\usage{
\method{print}{stanreg}(x, digits = 1, ...)
}
\arguments{
\item{x}{A fitted model object returned by one of the
\pkg{rstanarm} modeling functions. See \code{\link{stanreg-objects}}.}

\item{digits}{Number of digits to use for formatting numbers.}

\item{...}{Ignored.}
}
\value{
Returns \code{x}, invisibly.
}
\description{
The \code{print} method for stanreg objects displays a compact summary of the
fitted model. See the Details section below for a description of the printed 
output. For additional summary statistics and diagnostics use the 
\code{\link[=summary.stanreg]{summary}} method.
}
\details{
\subsection{Point estimates}{
Regardless of the estimation algorithm, point estimates are medians computed 
from simulations. For models fit using MCMC (\code{"sampling"}) the posterior
sample is used. For optimization (\code{"optimizing"}), the simulations are
generated from the asymptotic Gaussian sampling distribution of the
parameters. For the \code{"meanfield"} and \code{"fullrank"} variational
approximations, draws from the variational approximation to the posterior are
used. In all cases, the point estimates reported are the same as the values
returned by \code{\link[=coef.stanreg]{coef}}.
}
\subsection{Uncertainty estimates}{
The standard deviations reported (labeled MAD_SD in the print output) are 
computed from the same set of draws described above and are proportional to 
the median absolute deviation (\code{\link[stats]{mad}}) from the median. 
Compared to the raw posterior standard deviation, the MAD_SD will be more 
robust for long-tailed distributions. These are the same as the values 
returned by \code{\link[=se.stanreg]{se}}.
}
\subsection{Additional output}{
For models fit using MCMC or a variational approximation, the median and 
MAD_SD are also reported for mean_PPD, the sample average (\eqn{X = 
\bar{X}}{X = xbar}) posterior predictive distribution of the outcome.

For GLMs with group-specific terms (see \code{\link{stan_glmer}}) the printed 
output also shows point estimates of the standard deviations of the group 
effects (and correlations if there are both intercept and slopes that vary by
group).

For analysis of variance models (see \code{\link{stan_aov}}) models, an
ANOVA-like table is also displayed.
}
}
\seealso{
\code{\link{summary.stanreg}}, \code{\link{stanreg-methods}}
}

