% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_glmer.R
\name{stan_glmer}
\alias{stan_glmer}
\alias{stan_glmer.nb}
\alias{stan_lmer}
\title{Bayesian generalized linear models with group-specific terms via Stan}
\usage{
stan_glmer(formula, data = NULL, family = gaussian, subset, weights,
  na.action = getOption("na.action", "na.omit"), offset, contrasts = NULL,
  ..., prior = normal(), prior_intercept = normal(),
  prior_ops = prior_options(), prior_covariance = decov(),
  prior_PD = FALSE, algorithm = c("sampling", "meanfield", "fullrank"),
  adapt_delta = NULL, QR = FALSE)

stan_lmer(...)

stan_glmer.nb(..., link = "log")
}
\arguments{
\item{formula, data, family}{Same as for \code{\link[lme4]{glmer}}.}

\item{subset, weights, offset}{Same as \code{\link[stats]{glm}}.}

\item{na.action, contrasts}{Same as \code{\link[stats]{glm}}, but rarely 
specified.}

\item{...}{For \code{stan_glmer}, further arguments passed to 
\code{\link[rstan]{sampling}} (e.g. \code{iter}, \code{chains}, 
\code{cores}, etc.) or to \code{\link[rstan]{vb}} (if \code{algorithm} is 
\code{"meanfield"} or \code{"fullrank"}). For \code{stan_lmer} and 
\code{stan_glmer.nb}, \code{...} should also contain all relevant arguments
to pass to \code{stan_glmer} (except \code{family}).}

\item{prior}{The prior distribution for the regression coefficients. 
\code{prior} can be a call to \code{normal}, \code{student_t},
\code{cauchy}, \code{hs} or \code{hs_plus}. See \code{\link{priors}} for
details. To to omit a prior ---i.e., to use a flat (improper) uniform
prior--- set \code{prior} to \code{NULL}.}

\item{prior_intercept}{The prior distribution for the intercept.
\code{prior_intercept} can be a call to \code{normal}, \code{student_t} or
\code{cauchy}. See \code{\link{priors}} for details. To to omit a prior
---i.e., to use a flat (improper) uniform prior--- set
\code{prior_intercept} to \code{NULL}. (\strong{Note:} the prior
distribution for the intercept is set so it applies to the value when all
predictors are centered.)}

\item{prior_ops}{Additional options related to prior distributions. Can 
be \code{NULL} to omit a prior on the dispersion and see 
\code{\link{prior_options}} otherwise.}

\item{prior_covariance}{Cannot be \code{NULL}; see \code{\link{decov}} for
more information about the default arguments.}

\item{prior_PD}{A logical scalar (defaulting to \code{FALSE}) indicating
whether to draw from the prior predictive distribution instead of
conditioning on the outcome.}

\item{algorithm}{Character string (possibly abbreviated) indicating the 
estimation approach to use. Can be \code{"sampling"} for MCMC (the
default), \code{"optimizing"} for optimization, \code{"meanfield"} for
variational inference with independent normal distributions, or
\code{"fullrank"} for variational inference with a multivariate normal
distribution. See \code{\link{rstanarm-package}} for more details on the
estimation algorithms. NOTE: not all fitting functions support all four
algorithms.}

\item{adapt_delta}{Only relevant if \code{algorithm="sampling"}. See 
\code{\link{adapt_delta}} for details.}

\item{QR}{A logical scalar (defaulting to \code{FALSE}) but if \code{TRUE}
applies a scaled \code{\link{qr}} decomposition to the design matrix, 
\eqn{X = Q^\ast R^\ast}{X = Q* R*}, where 
\eqn{Q^\ast = Q \sqrt{n-1}}{Q* = Q (n-1)^0.5} and
\eqn{R^\ast = \frac{1}{\sqrt{n-1}} R}{R* = (n-1)^(-0.5) R}. The coefficients
relative to \eqn{Q^\ast}{Q*} are obtained and then premultiplied by the
inverse of \eqn{R^{\ast}}{R*} to obtain coefficients relative to the
original predictors, \eqn{X}. These transformations do not change the 
likelihood of the data but are recommended for computational reasons when 
there are multiple predictors. However, because the coefficients relative
to \eqn{Q^\ast}{Q*} are not very interpretable it is hard to specify an 
informative prior. Setting \code{QR=TRUE} is therefore only recommended 
if you do not have an informative prior for the regression coefficients.}

\item{link}{For \code{stan_glmer.nb} only, the link function to use. See 
\code{\link{neg_binomial_2}}.}
}
\value{
A \link[=stanreg-objects]{stanreg} object is returned 
for \code{stan_glmer, stan_lmer, stan_glmer.nb}.
}
\description{
Bayesian inference for GLMs with group-specific coefficients that have 
unknown covariance matrices with flexible priors.
}
\details{
The \code{stan_glmer} function is similar in syntax to 
  \code{\link[lme4]{glmer}} but rather than performing (restricted) maximum 
  likelihood estimation of generalized linear models, Bayesian estimation is 
  performed via MCMC. The Bayesian model adds independent priors on the 
  regression coefficients (in the same way as \code{\link{stan_glm}}) and
  priors on the terms of a decomposition of the covariance matrices of the
  group-specific parameters. See \code{\link{priors}} for more information
  about the priors.
  
  The \code{stan_lmer} function is equivalent to \code{stan_glmer} with 
  \code{family = gaussian(link = "identity")}. 
  
  The \code{stan_glmer.nb} function, which takes the extra argument
  \code{link}, is a simple wrapper for \code{stan_glmer} with 
  \code{family = \link{neg_binomial_2}(link)}.
}
\examples{
# see help(example_model) for details on the model below
if (!exists("example_model")) example(example_model) 
print(example_model, digits = 1)

}
\references{
Gelman, A. and Hill, J. (2007). \emph{Data Analysis Using
  Regression and Multilevel/Hierarchical Models.} Cambridge University Press,
  Cambridge, UK. (Ch. 11-15)
}
\seealso{
\code{\link{stanreg-methods}} and 
\code{\link[lme4]{glmer}}.

The vignette for \code{stan_glmer} and the \emph{Hierarchical 
  Partial Pooling} vignette.
}

