/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.xpdl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jdom.Document;
import org.jdom.Element;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.quality.IQualityFunction;
import org.vikamine.kernel.subgroup.quality.functions.QualityFunctionRegistry;
import org.vikamine.kernel.subgroup.search.AbstractMiningTask;
import org.vikamine.kernel.subgroup.selectors.DefaultSGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGenerator;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGeneratorFactory;
import org.vikamine.kernel.subgroup.selectors.SelectorGeneratorUtils;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.subgroup.target.SelectorTarget;
import org.vikamine.kernel.util.FilterUtils;
import org.vikamine.kernel.util.Filters;
import org.vikamine.kernel.xpdl.AttributeValueHelper;
import org.vikamine.kernel.xpdl.DatasetProvider;
import org.vikamine.kernel.xpdl.EConstraintTyp;
import org.vikamine.kernel.xpdl.ETyp;
import org.vikamine.kernel.xpdl.IConstraint;
import org.vikamine.kernel.xpdl.MAttribute;
import org.vikamine.kernel.xpdl.MValue;
import org.vikamine.kernel.xpdl.XMLData;
import org.vikamine.kernel.xpdl.XMLException;

public abstract class AbstractMiningTaskInterpreter {
    protected XMLData doc;
    protected AbstractMiningTask task;

    protected AbstractMiningTaskInterpreter(XMLData doc, AbstractMiningTask task) {
        this.doc = doc;
        this.task = task;
    }

    protected AbstractMiningTaskInterpreter(Document doc, DatasetProvider provider, AbstractMiningTask task) {
        this(new XMLData(doc), provider, task);
    }

    protected AbstractMiningTaskInterpreter(File miningTask, DatasetProvider provider, AbstractMiningTask task) throws IOException {
        this(new XMLData(miningTask), provider, task);
    }

    protected AbstractMiningTaskInterpreter(String miningTask, DatasetProvider provider, AbstractMiningTask task) throws UnsupportedEncodingException {
        this(new XMLData(new ByteArrayInputStream(miningTask.getBytes("UTF-8"))), provider, task);
    }

    protected AbstractMiningTaskInterpreter(XMLData data, DatasetProvider provider, AbstractMiningTask task) {
        this.doc = data;
        this.task = task;
        if (!provider.providesDataset(this.doc.getDataset().getName())) {
            throw new IllegalArgumentException("data file does not exist: " + this.doc.getDataset().getName());
        }
        task.setOntology(provider.getDataset(this.doc.getDataset().getName()));
        this.init();
    }

    public AbstractMiningTask getTask() {
        return this.task;
    }

    protected void init() {
        this.initPopulation();
        this.initTarget();
        this.task.setMethodType(this.doc.getMethod().getName());
        this.initInitialSubgroup();
        this.initConstraints();
        this.initSearchSpace();
        this.initQualityFunction();
    }

    protected void initConstraints() {
        this.task.setMaxSGCount(30);
        this.task.setMinSubgroupSize(0.0);
        for (IConstraint constr : this.doc.getMConstraints().getConstraints()) {
            EConstraintTyp typ = constr.getName();
            this.setConstraintForType(constr, typ);
        }
    }

    private void initInitialSubgroup() {
        DefaultSGSelector sel = null;
        Ontology ont = this.task.getOntology();
        SG sg = new SG(ont.getDataView(), this.task.getTarget());
        if (this.doc.getInitialSubgroup() != null) {
            for (MAttribute a : this.doc.getInitialSubgroup().getOp().getAttributes()) {
                HashSet<Value> values = new HashSet<Value>();
                if (ont.getDataset().getAttribute(a.getName()) == null) {
                    throw new XMLException("Attribute " + a.getName() + " does not exist");
                }
                for (MValue k : a.getValues()) {
                    Value val;
                    if (!k.getTyp().equals((Object)ETyp.include) || !(val = AttributeValueHelper.getAttributeValue(ont.getDataset().getAttribute(a.getName()), k.getValue())).getDescription().equals(k.getValue())) continue;
                    values.add(val);
                }
                sel = new DefaultSGSelector(ont.getDataset().getAttribute(a.getName()), values);
                sg.getSGDescription().add(sel);
            }
        }
        this.task.setInitialSG(sg);
    }

    private void initPopulation() {
        DefaultSGSelector sel = null;
        ArrayList<SGSelector> selectors = new ArrayList<SGSelector>();
        for (MAttribute a : this.doc.getDataset().getRes().getAttributes()) {
            HashSet<Value> values = new HashSet<Value>();
            Ontology ont = this.task.getOntology();
            if (ont.getDataset().getAttribute(a.getName()) == null) {
                throw new XMLException("Attribute " + a.getName() + " doesn't exist");
            }
            for (MValue k : a.getValues()) {
                Value val;
                if (!k.getTyp().equals((Object)ETyp.include) || !(val = AttributeValueHelper.getAttributeValue(ont.getDataset().getAttribute(a.getName()), k.getValue())).getDescription().equals(k.getValue())) continue;
                values.add(val);
            }
            sel = new DefaultSGSelector(ont.getDataset().getAttribute(a.getName()), values);
            selectors.add(sel);
        }
        this.task.getOntology().refinePopulation(selectors);
    }

    private void initQualityFunction() {
        String name = this.doc.getQualityFunction().getName();
        for (IQualityFunction function : QualityFunctionRegistry.getInstance().getQualityFunctions()) {
            if (!name.equals(function.getName()) && !name.equals(function.getClass().getSimpleName())) continue;
            this.task.setQualityFunction(function.clone());
            break;
        }
        if (this.task.getQualityFunction() == null) {
            throw new IllegalArgumentException("Quality Function not found: " + name);
        }
        this.task.setInvertQualityFunction(this.doc.getQualityFunction().isInvert());
    }

    protected void initSearchSpace() {
        ArrayList<SGSelector> searchSpace = new ArrayList<SGSelector>();
        Element searchSpaceElem = this.doc.getDoc().getRootElement().getChild("searchSpace");
        String generatorAttributeStr = searchSpaceElem.getAttributeValue("generator");
        SGSelectorGenerator generator = SGSelectorGeneratorFactory.createSimpleValueGenerator(this.task.isIgnoreDefaultValues());
        if (generatorAttributeStr != null) {
            generator = this.getGenerator(generatorAttributeStr);
        }
        if (this.doc.getSearchSpace().isUseAll()) {
            searchSpace.addAll(SelectorGeneratorUtils.generateSelectors(generator, this.task.getOntology().getAttributes(), this.task.getOntology().getDataView()));
        } else if (this.doc.getSearchSpace().isUseAllNominal()) {
            LinkedHashSet<Attribute> attributes = this.task.getOntology().getAttributes();
            FilterUtils.applyFilter(Filters.NOMINAL_ATTRIBUTE_FILTER, attributes);
            searchSpace.addAll(SelectorGeneratorUtils.generateSelectors(generator, attributes, this.task.getOntology().getDataView()));
        } else {
            for (Element attrElem : searchSpaceElem.getChildren("attribute")) {
                String attName = attrElem.getAttributeValue("name");
                Attribute att = this.task.getOntology().getAttribute(attName);
                if (att == null || this.task.getTarget().getAttributes().contains(att)) continue;
                generatorAttributeStr = searchSpaceElem.getAttributeValue("generator");
                SGSelectorGenerator generatorForThisAttribute = generator;
                if (generatorAttributeStr != null) {
                    generatorForThisAttribute = this.getGenerator(generatorAttributeStr);
                }
                searchSpace.addAll(generatorForThisAttribute.getSelectors(att, this.task.getOntology().getDataView()));
            }
        }
        this.task.setSearchSpace(searchSpace);
    }

    private SGSelectorGenerator getGenerator(String generatorAttributeStr) {
        if (generatorAttributeStr.equals("simplevaluegenerator")) {
            return SGSelectorGeneratorFactory.createSimpleValueGenerator(this.task.isIgnoreDefaultValues());
        }
        return null;
    }

    private void initTarget() {
        DefaultSGSelector sel = null;
        String targetType = this.doc.getTarget().getType();
        MAttribute mAttribute = this.doc.getTarget().getAttribute();
        IDataRecordSet drs = this.task.getOntology().getDataset();
        if (drs.getAttribute(mAttribute.getName()) == null) {
            throw new XMLException("Attribute " + mAttribute.getName() + " doesn't exist");
        }
        Attribute attribute = drs.getAttribute(mAttribute.getName());
        for (MValue k : mAttribute.getValues()) {
            Value val = AttributeValueHelper.getAttributeValue(attribute, k.getValue());
            if (!val.getDescription().equals(k.getValue())) continue;
            sel = new DefaultSGSelector(attribute, val);
        }
        if (targetType.equals("boolean")) {
            this.task.setTarget(new SelectorTarget(sel));
        } else {
            Attribute att = drs.getAttribute(this.doc.getTarget().getAttribute().getName());
            if (att.isNumeric()) {
                NumericAttribute nAtt = (NumericAttribute)att;
                this.task.setTarget(new NumericTarget(nAtt));
            } else {
                throw new IllegalStateException("not a numeric attribute!");
            }
        }
    }

    protected abstract void setConstraintForMaxSelectors(IConstraint var1, EConstraintTyp var2);

    protected final void setConstraintForType(IConstraint constr, EConstraintTyp type) {
        switch (type) {
            case maxK: {
                this.task.setMaxSGCount(((Double)constr.getValue()).intValue());
                break;
            }
            case relevantSubgroupsOnly: {
                this.task.setSuppressStrictlyIrrelevantSubgroups((Boolean)constr.getValue());
                break;
            }
            case minTPSupportAbsolute: {
                this.task.setMinTPSupportAbsolute((Double)constr.getValue());
                break;
            }
            case minQuality: {
                this.task.setMinQualityLimit((Double)constr.getValue());
                break;
            }
            case minSubgroupSize: {
                this.task.setMinSubgroupSize((Double)constr.getValue());
                break;
            }
            case minTPSupportRelative: {
                this.task.setMinTPSupportRelative((Double)constr.getValue());
                break;
            }
            case weightedCovering: {
                this.task.setWeightedCovering((Boolean)constr.getValue());
                break;
            }
            case maxSelectors: {
                this.setConstraintForMaxSelectors(constr, type);
                break;
            }
            case ignoreDefaultValues: {
                this.task.setIgnoreDefaultValues((Boolean)constr.getValue());
            }
        }
    }
}

