/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.util.VKMUtil;

public class DataRecordIteration
implements Iterable<DataRecord> {
    private SizableInstanceIterator instanceIterator;

    public DataRecordIteration(IDataRecordSet dataRecordSet) {
        this.instanceIterator = new DataRecordSetBackedPopulationInstanceIterator(dataRecordSet);
    }

    public DataRecordIteration(Iterator<DataRecord> instanceIterator) {
        this.instanceIterator = instanceIterator instanceof SizableInstanceIterator ? (SizableInstanceIterator)instanceIterator : new CachedPopulationInstanceIterator(instanceIterator);
    }

    @Override
    public Iterator<DataRecord> iterator() {
        return this.instanceIterator.copy();
    }

    public Collection<DataRecord> instances() {
        return Collections.unmodifiableCollection(this.instanceIterator.getInstances());
    }

    public int size() {
        return this.instanceIterator.size();
    }

    private static class CachedPopulationInstanceIterator
    extends SizableInstanceIterator {
        private Iterator<DataRecord> referencedInstancesIterator;
        private List<DataRecord> referencedInstances;
        private int size = 0;

        private CachedPopulationInstanceIterator() {
        }

        protected CachedPopulationInstanceIterator(Iterator<DataRecord> instanceIterator) {
            this.init(instanceIterator);
        }

        @Override
        CachedPopulationInstanceIterator copy() {
            CachedPopulationInstanceIterator iter = new CachedPopulationInstanceIterator();
            iter.referencedInstances = this.referencedInstances;
            iter.referencedInstancesIterator = this.referencedInstances == null ? this.referencedInstancesIterator : iter.referencedInstances.iterator();
            iter.size = this.size;
            return iter;
        }

        @Override
        List<DataRecord> getInstances() {
            return this.referencedInstances;
        }

        @Override
        public boolean hasNext() {
            return this.referencedInstancesIterator.hasNext();
        }

        private void init(Iterator<DataRecord> theInstanceIterator) {
            LinkedList<DataRecord> tmp = new LinkedList<DataRecord>();
            while (theInstanceIterator.hasNext()) {
                DataRecord instance = theInstanceIterator.next();
                assert (instance != null);
                tmp.add(instance);
                ++this.size;
            }
            this.referencedInstances = new ArrayList<DataRecord>(this.size);
            this.referencedInstances.addAll(tmp);
            this.referencedInstancesIterator = this.referencedInstances.iterator();
        }

        @Override
        public DataRecord next() {
            return this.referencedInstancesIterator.next();
        }

        @Override
        public void remove() {
            this.referencedInstancesIterator.remove();
        }

        @Override
        int size() {
            return this.size;
        }
    }

    private static class DataRecordSetBackedPopulationInstanceIterator
    extends SizableInstanceIterator {
        private final IDataRecordSet dataRecordSet;
        private final Iterator<DataRecord> iterator;

        public DataRecordSetBackedPopulationInstanceIterator(IDataRecordSet dataRecordSet) {
            this.dataRecordSet = dataRecordSet;
            this.iterator = dataRecordSet.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public DataRecord next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        int size() {
            return this.dataRecordSet.getNumInstances();
        }

        @Override
        SizableInstanceIterator copy() {
            return new DataRecordSetBackedPopulationInstanceIterator(this.dataRecordSet);
        }

        @Override
        List<DataRecord> getInstances() {
            return VKMUtil.asList(this.dataRecordSet.iterator());
        }
    }

    private static abstract class SizableInstanceIterator
    implements Iterator<DataRecord> {
        private SizableInstanceIterator() {
        }

        abstract int size();

        abstract SizableInstanceIterator copy();

        abstract List<DataRecord> getInstances();
    }
}

