/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.quality.functions;

import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGStatistics;
import org.vikamine.kernel.subgroup.SGStatisticsNumeric;
import org.vikamine.kernel.subgroup.quality.AbstractQFStatisticBased;

public class GenericMedianQF
extends AbstractQFStatisticBased {
    private double param;

    public GenericMedianQF(double param) {
        this.param = param;
    }

    public double getParam() {
        return this.param;
    }

    public void setParam(double param) {
        this.param = param;
    }

    @Override
    public double evaluate(SGStatistics statistics) {
        SGStatisticsNumeric statsNum = (SGStatisticsNumeric)statistics;
        if (statistics.getSubgroupSize() == 0.0) {
            return 0.0;
        }
        return Math.pow(statistics.getSubgroupSize(), this.param) * (statsNum.getSGMedian() - statsNum.getPopulationMedian());
    }

    public double evaluateNum(double subgroupSize, double sgMedian, double popMedian) {
        if (subgroupSize == 0.0) {
            return 0.0;
        }
        return Math.pow(subgroupSize, this.param) * (sgMedian - popMedian);
    }

    @Override
    public String getID() {
        return "GenericMedianQF, a=" + this.param;
    }

    @Override
    public String getName() {
        return this.getID();
    }

    @Override
    public boolean isApplicable(SG subgroup) {
        return subgroup.getTarget().isNumeric();
    }

    @Override
    public AbstractQFStatisticBased clone() {
        return new GenericMedianQF(this.param);
    }
}

