/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SubsetGenerator {
    public static void main(String[] args) {
        ArrayList<Integer> base = new ArrayList<Integer>();
        int size = 0;
        while (size < 3) {
            base.add(size);
            ++size;
        }
        List subsetList = SubsetGenerator.generateSubsetHalf(base);
        System.out.println(subsetList);
        System.out.println(subsetList.size());
    }

    public static <T> List<List<T>> generateSubset(List<T> baseSet) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        Iterator<List<T>> it = SubsetGenerator.subsetIterator(baseSet);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T> List<List<T>> generateSubsetHalf(List<T> baseSet) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        Iterator<List<T>> it = SubsetGenerator.subsetMaxLengthIterator(baseSet, baseSet.size() / 2, false);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T> List<List<T>> generateMaxLengthSubset(List<T> baseSet, int maxLength, boolean includeMaxLength) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        Iterator<List<T>> it = SubsetGenerator.subsetMaxLengthIterator(baseSet, maxLength, includeMaxLength);
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    public static <T> Iterator<List<T>> subsetIterator(final List<T> baseSet) {
        int size = baseSet.size();
        if (size > 63) {
            throw new IllegalArgumentException("baseSet is too large! Max allowed size is 63");
        }
        return new Iterator<List<T>>(size){
            long counter;
            {
                this.counter = (long)Math.pow(2.0, n);
            }

            @Override
            public boolean hasNext() {
                return this.counter > 0L;
            }

            @Override
            public List<T> next() {
                --this.counter;
                ArrayList aSubset = new ArrayList();
                int i = SubsetGenerator.nextSetBit(this.counter, 0);
                while (i >= 0) {
                    aSubset.add(baseSet.get(i));
                    i = SubsetGenerator.nextSetBit(this.counter, i + 1);
                }
                return aSubset;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<List<T>> subsetMaxLengthIterator(final List<T> baseSet, final int maxLength, final boolean includeAllWithMaxLength) {
        int size = baseSet.size();
        if (size > 63) {
            throw new IllegalArgumentException("baseSet is too large! Max allowed size is 63");
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength is smaller than 0");
        }
        return new Iterator<List<T>>(size){
            long counter;
            {
                this.counter = (long)Math.pow(2.0, n);
            }

            @Override
            public boolean hasNext() {
                return this.counter > 0L;
            }

            @Override
            public List<T> next() {
                long counterInvert;
                --this.counter;
                int bitCount = Long.bitCount(this.counter);
                if (bitCount > maxLength) {
                    return this.next();
                }
                if (bitCount == maxLength && !includeAllWithMaxLength && (this.counter & 1L) > 0L && (counterInvert = this.counter & 0xFFFFFFFFFFFFFFFFL) > (long)maxLength) {
                    return this.next();
                }
                ArrayList aSubset = new ArrayList(bitCount);
                int i = SubsetGenerator.nextSetBit(this.counter, 0);
                while (i >= 0) {
                    aSubset.add(baseSet.get(i));
                    i = SubsetGenerator.nextSetBit(this.counter, i + 1);
                }
                return aSubset;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static int nextSetBit(long word, int fromIndex) {
        long WORD_MASK = -1L;
        return (word &= -1L << fromIndex) == 0L ? -1 : Long.numberOfTrailingZeros(word);
    }
}

