% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/cg_documents.R
\name{cg_documents}
\alias{cg_documents}
\title{Search for data on documents}
\usage{
cg_documents(document_id = NULL, document_type = NULL, chamber = NULL,
  committee_id = NULL, committee_names = NULL, congress = NULL,
  house_event_id = NULL, hearing_type_code = NULL, hearing_title = NULL,
  published_at = NULL, bill_id = NULL, description = NULL,
  version_code = NULL, bioguide_id = NULL, occurs_at = NULL,
  urls = NULL, text = NULL, text_preview = NULL, witness = NULL,
  fields = NULL, page = 1, per_page = 20, order = NULL, key = NULL,
  as = "table", ...)
}
\arguments{
\item{document_id}{A unique id for each document.}

\item{document_type}{Document types are taken from the House document type code. See Details.}

\item{chamber}{House or Senate}

\item{committee_id}{Acronym a committee is associated with the document.}

\item{committee_names}{Full names of the committees associated with the document.}

\item{congress}{Session of Congress.}

\item{house_event_id}{Unique ID for each hearing, assigned by the House.}

\item{hearing_type_code}{This describes if the meeting is a "markup", "meeting" or "hearing".}

\item{hearing_title}{Title of the hearing associated with the document.}

\item{published_at}{Date and time of publication.}

\item{bill_id}{Bill ID associated with the document.}

\item{description}{Description of the hearing.}

\item{version_code}{The short-code for what stage the version of the bill. See GPO for
explanations of the version code.}

\item{bioguide_id}{Unique identifier for a member of Congress if they are associated
with the document.}

\item{occurs_at}{Date and time of a hearing associated with the document.}

\item{urls}{The original link to the document. The permalink is a link to a copy
of the document hosted by the Sunlight Foundation.}

\item{text}{Extracted text from the document.}

\item{text_preview}{A preview of the text.}

\item{witness}{Information about a witness associated with a document.}

\item{fields}{You can request specific fields by supplying a vector of fields names. Many fields
are not returned unless requested. If you don't supply a fields parameter, you will get the
most commonly used subset of fields only. To save on bandwidth, parsing time, and confusion,
it's recommended to always specify which fields you will be using.}

\item{page}{Page to return. Default: 1. You can use this in combination with the
per_page parameter to get more than the default or max number of results per page.}

\item{per_page}{Number of records to return. Default: 20. Max: 50.}

\item{order}{Sort results by one or more fields with the order parameter. order is
optional, but if no order is provided, the order of results is not guaranteed to be predictable.
Append \code{__asc} or \code{__desc} to the field names to control sort direction. The default
direction is \code{desc}, because it is expected most queries will sort by a date. Any field
which can be used for filtering may be used for sorting. On full-text search endpoints (URLs
ending in \code{/search}), you may sort by score to order by relevancy.}

\item{key}{your SunlightLabs API key; loads from environment variable from .Renviron or
from an option from .Rprofile}

\item{as}{(character) One of table (default), list, or response (httr response object).
When table is requested, the default, a table is not always returned, but is returned almost
always. You can then make a table yourself if you like.}

\item{...}{Optional additional curl options (debugging tools mostly). See examples.}
}
\description{
Search for data on documents
}
\details{
\itemize{
 \item CV - Committee vote
 \item WS - Witness statement
 \item WT - Witness truth statement
 \item WB - Witness biography
 \item CR - Committee report
 \item BR - Bill
 \item FA - Floor amendment
 \item CA - Committee amendment
 \item HT - Transcript
 \item WD - Witness document
}
\emph{other} is used for all other documents.
}
\examples{
\dontrun{
cg_documents()
cg_documents(per_page=4)
cg_documents(per_page=4)
cg_documents(fields=c('document_id','type'))

# most parameters are vectorized, pass in more than one value
cg_documents(chamber = c("house", "senate"))
}
}

