% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsurfer.R
\name{subjectDistributionTableToLatex}
\alias{subjectDistributionTableToLatex}
\title{Convert Subject Distribution Table To LaTeX}
\usage{
subjectDistributionTableToLatex(subjectDistributionTable,
  caption = "Placeholder Caption", label = "table:SubjectDistributionTable",
  roundDP = 1)
}
\arguments{
\item{subjectDistributionTable}{The subject distribution table created using subjectDistributionTable()}

\item{caption}{The caption to give the table in LaTeX}

\item{label}{The label to give the table in LaTeX}

\item{roundDP}{The number of decimal places to round the numbers to on the table}
}
\value{
The LaTeX code representing the subject distribution table
}
\description{
Converts a subject distribution table created using subjectDistributionTable() into text which can be used in the typesetting language LaTeX. The table created can have its caption and label specified using the respective function arguments. The decimal point rounding can be specified by the function argument roundDP.
}
\examples{
all <- generaterandomsubjects(1000)
all$Age <- stats::runif(1000,50,80)
all <- addrandomgender(all)
all <- addrandomdiagnosis(all)
sdt <- subjectDistributionTable(all, "Diagnosis")
subjectDistributionTableToLatex(subjectDistributionTable = sdt,
                                caption="Subject Distribution Table",
                                label="table:SDT", roundDP=1)
}
\author{
Alexander Luke Spedding, \email{alexspedding271@gmail.com}
}
